#!/usr/bin/env perl

use strict;
use warnings;

#use LibCcsds;
#use LibCcsds::CcsdsPacket;
use LibCcsds::CcsdsReader;
use LibCcsds::GapCcsdsReader;
#use LibCcsds::CcsdsPacket::EisCcsdsPacket;
use Hinode::EIS::EisCcsds::EisCcsdsPacket;

print "Creating foo with CcsdsPacket->create();\n";
my $foo = CcsdsPacket->create();
print "Creating bar with CcsdsPacket->new();\n";
my $bar = CcsdsPacket->new();
print "Creating faz with CcsdsPacket->create(has_secondary_header => 1, secondary_header_length => 4);\n";
my $faz = CcsdsPacket->create(has_secondary_header => 1, secondary_header_length => 4);
print "Creating baz with CcsdsPacket->create(has_secondary_header => 1, secondary_header_length => 6, endian => \"small\");\n";
my $baz = CcsdsPacket->create(has_secondary_header => 1, secondary_header_length => 6, endian => "small");
print "Creating boo with EisCcsdsPacket->new(secondary_header_length => 10);\n";
my $boo = EisCcsdsPacket->new(secondary_header_length => 10);

print "Debug:\n";
print "foo: ", $foo->hasSecondaryHeader(), ", ", $foo->secondaryHeaderLength(), ", ", $foo->endian(), "\n";
print "bar: ", $bar->hasSecondaryHeader(), ", ", $bar->secondaryHeaderLength(), ", ", $bar->endian(), "\n";
print "faz: ", $faz->hasSecondaryHeader(), ", ", $faz->secondaryHeaderLength(), ", ", $faz->endian(), "\n";
print "baz: ", $baz->hasSecondaryHeader(), ", ", $baz->secondaryHeaderLength(), ", ", $baz->endian(), "\n";
print "boo: ", $boo->hasSecondaryHeader(), ", ", $boo->secondaryHeaderLength(), ", ", $boo->endian(), "\n";

print "\nCreating reader with CcsdsReader->new(packet_type => 'Eis');\n";
#my $reader = CcsdsReader->new();
#my $reader = CcsdsReader->new(packet_type => $boo);
my $reader = CcsdsReader->new(packet_type => 'Eis');
#my $reader = GapCcsdsReader->new(packet_type => 'Eis');

print "primary header len ", $reader->{_packet}->primaryHeaderLength(), "\n";
print "secondary header len ", $reader->{_packet}->secondaryHeaderLength(), "\n";
#die;
#if ($reader->openForReading("/Users/mcrw/Downloads/eis_sts_20180131_0000002610")) {
if ($reader->open("/Users/mcrw/Downloads/eis_sts_20180131_0000002610")) {
    print "Opened\n";
    my $count = 0;
    while(1) {
	last unless $reader->nextPacket();
#	$reader->packet()->printHeaders();
	$reader->{_packet}->printHeaders();
	++$count;
	last if ($count == 10);
    }
    $reader->closeInput();
    print "Closed\n";
}
$reader->debug();
