#!/usr/bin/env perl

use strict;
use warnings;

#use LibCcsds;
#use LibCcsds::CcsdsPacket;
#use LibCcsds::EisCcsds;
use Hinode::EIS::EisCcsds;
use LibCcsds::CcsdsReader;
#use LibCcsds::CcsdsPacket::EisCcsdsPacket;
use Hinode::EIS::EisCcsds::EisCcsdsPacket;

# Test the ccsds reader

print "\nCreating interface with CcsdsInterface->new();\n";

my $int = CcsdsInterface->new();
$int->set_trace_flag(1);

print "\nCreating reader with CcsdsReader->new(packet_type => 'Eis');\n";
my $reader = CcsdsReader->new(packet_type => 'Eis');

print "primary header len ", $reader->{_packet}->primaryHeaderLength(), "\n";
print "secondary header len ", $reader->{_packet}->secondaryHeaderLength(), "\n";
#die;
my $use_apid = 0;

#my $fn = "/Users/mcrw/tmp/foo_headers.txt";
#open(FH, ">>", $fn) or die "Can't open foo_headers.txt: $!";

#if ($reader->open("/Users/mcrw/Downloads/eis_dmp_20210930_0858225168")) {
#if ($reader->open("/Users/mcrw/Downloads/eis_dmp_20210930_2211142288")) {
foreach my $file (`ls /Users/mcrw/Downloads/eis_dmp_20210930_22*`) {
    chomp $file;
    if ($reader->open($file)) {
	print "Opened\n";
	my $count = 0;
	while(1) {
	    if ($use_apid) {
		###	    if ($reader->nextPacketWithApid(0x5C4)) {
		####	    if ($reader->nextPacketWithApid($EisCcsds::status_apids{'sts1'})) {
		if ($reader->nextPacketWithApid(EisCcsds::apid_for_type('sts1'))) {
#		    $reader->{_packet}->printHeaders(*FH);
		    my $apid = $reader->{_packet}->packetApid();
		    print EisCcsds::type_for_apid($apid), "\n";
		    ++$count;
		}
	    }
	    else {
		last unless $reader->nextPacket();
		#	    $reader->packet()->printHeaders();
#		$reader->{_packet}->printHeaders(*FH);
		my $apid = $reader->{_packet}->packetApid();
		print EisCcsds::type_for_apid($apid), "\n";
		#	    print $EisCcsds::status_apid_strings{$apid}, "\n";
		my $apidd = $reader->{_packet}->packetApid(decoded => 1);
		print "Decoded apid = $apidd (0x", sprintf("%04x", $apidd), ")\n";
		++$count;
#		my($conf_flag, $seq_flag, $dsc, $len, $mem_table, $user, $addr) = $reader->{_packet}->dmp_decode();
		my($conf_flag, $seq_flag, $dsc, $len, $mem_table, $user, $addr) = EisCcsds::dmp_decode($reader->{_packet});
		print "seq: $seq_flag, dsc: $dsc, len: $len, mem: $mem_table (0x", sprintf("%02X", $mem_table), ") user: $user (0x", sprintf("%02X", $user), ", ", $EisCcsds::memory_table_ids{$user},"), addr: ", sprintf("0x%X", $addr), "\n";
	    }
	    #	last if ($count == 10);
	}
	$reader->closeInput();
	print "Closed\n";
    }
}
#close FH;
