#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$src_dir   = "$HOME/tmp";
$exp_rec   = "exp_rec";
$db_dir    = "$HOME/work/localdata/database/exposure";
$db        = "exposures_";

foreach $year (2006 .. 2008) {
    dbmopen(%db, "$db_dir/$db$year.db", '0777') or die "Can't open database $db$year.db: $!";
    foreach $month qw(01 02 03 04 05 06 07 08 09 10 11 12) {
	$src_file = "$src_dir/" . "$exp_rec" . "_$year$month.txt";
	if(!open(EC, "< $src_file")) {
	    print STDERR "Couldn't open $src_dir/$exp_count_$year$month.txt: $!\n";
	    next;
	}
	while(<EC>) {
	    next if /^\#/;
	    chomp;
	    @data = split;
	    $key = shift @data;
	    $line = join ' ', @data;
	    $line =~ s/[ ]+/ /g;
#	    print "File: $key -> $line\n";
	    if(defined($db{$key})) {
		$string = join(' ', ($db{$key}));
#		print "Updated entry will be: $key -> [", $string . ' ' . $line, "]\n";
		$db{$key} = $string . ' ' . $line;
	    }
	    else {
		$string = "0 0 0 0 0 0 0 0 0 0 0 " . $line;
#		print "New entry will be: $key -> [$string]\n";
		$db{$key} = $string;
	    }
	}
	close EC;
    }
    dbmclose %db;
}

# Expect 2 arguments: year (yyyy) and a directory name



#$year = shift;
#$dir  = shift;

#print "$year $dir\n";

#while(<>) {

#}
