#!/usr/local/bin/perl

use strict;
use Pod::Usage;
use Getopt::Long;

=pod
    
my $message_text  = "This text precedes the usage message.";
my $exit_status   = 2;          ## The exit status to use
my $verbose_level = 0;          ## The verbose level to use
my $filehandle    = \*STDERR;   ## The filehandle to write to
pod2usage($message_text);
pod2usage($exit_status);
pod2usage( { -message => $message_text ,
               -exitval => $exit_status  ,  
               -verbose => $verbose_level,  
	     -output  => $filehandle } );
  pod2usage(   -msg     => $message_text ,
               -exitval => $exit_status  ,  
               -verbose => $verbose_level,  
               -output  => $filehandle );
  pod2usage(   -verbose => 2,
               -noperldoc => 1  );
  pod2usage(   -verbose => 2,
               -perlcmd => $path_to_perl,
               -perldoc => $path_to_perldoc,
               -perldocopt => $perldoc_options );

=cut

=pod
## Parse options
my %opt;
GetOptions(\%opt, "help|?", "man", "flag1")  ||  pod2usage(2);
pod2usage(1)  if ($opt{help});
pod2usage(-exitval => 0, -verbose => 2)  if ($opt{man});
## Check for too many filenames
pod2usage("$0: Too many files given.\n")  if (@ARGV > 1);
=cut

## Parse options
my %opt;
GetOptions(\%opt, "help|?", "man", "flag1")  || pod2usage(-verbose => 0);
pod2usage(-verbose => 1)  if ($opt{help});
pod2usage(-verbose => 2)  if ($opt{man});
## Check for too many filenames
pod2usage(-verbose => 2, -message => "$0: Too many files given.\n") if (@ARGV > 1);

foreach my $i (1 .. 3) {
    print "$i\n";
    sleep(1);
}
