#!/usr/local/bin/perl -w
use strict;

my $copy = 0;

while (my $opt = shift) {
    $copy = 1 if $opt eq "-c";
}

die "Script is intended to be used in the [eis/level0]/cal directory"
    unless $ENV{'PWD'} =~ m|/cal$|;

do_dir(".");

my %dirs;

sub do_file {
    my $f = shift;
    my $yyyymmdd = '(\d{4})(\d{2})(\d{2})';
    return unless $f =~ m|/(eis_l0_$yyyymmdd\_\d{6}\.fits\.gz)|;
    my $dest = "../$2/$3/$4/$1";
    if (-f $dest) { print "# $dest - exists - \n"; return; }
    print "mkdir ../$2\n"       unless -d "../$2" || $dirs{"$2"};
    print "mkdir ../$2/$3\n"    unless -d "../$2/$3" || $dirs{"$2$3"};
    print "mkdir ../$2/$3/$4\n" unless -d "../$2/$3/$4" || $dirs{"$2$3$4"};
    $dirs{"$2"} = $dirs{"$2$3"} = $dirs{"$2$3$4"} = 1;
    if ($copy) {
	print "cp -p $f ../$2/$3/$4/";
    } else {
	print "ln $f ../$2/$3/$4/$1";
    }
    print "\n";
}

sub do_dir {
    my $dir = shift;
    foreach my $e (glob("$dir/*")) {
	do_file($e) if -f $e;
	do_dir($e) if -d $e;
    }
}
