#!/bin/sh

source ${HINODE_LIB}/leap.sh

function create_feb () {
    y=$1
    m=$2
    file=$3
    leap=$(is_leap_year ${y})

    echo create_feb ${y} ${m} ${file}

    days='01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28'
    if [[ ${m} == "02" ]] ; then
	if [[ ${leap} == "true" ]] ; then
	    days='01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29'
	fi
    fi

#    for d in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 ; do
    for d in ${days} ; do
	echo "eis_daily_check, '/home/sbukeis/data/status/${y}/${m}/${d}/','/home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt'" >> ${file}
    done
}

function check_feb () {
    y=$1
    m=$2
    leap=$(is_leap_year ${y})
    echo check_feb ${y} ${m}
    
    days='01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28'
    if [[ ${m} == "02" ]] ; then
	if [[ ${leap} == "true" ]] ; then
	    days='01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29'
	fi
    fi
#    for d in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 ; do
    for d in ${days} ; do
	/bin/cat /home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt | awk -f '/home/sbukeis/src/add_range.awk' > /home/sbukeis/data/status/${y}/${m}/${d}/plots/${y}${m}${d}_check.txt
	/bin/rm /home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt
    done
}

function create_30 () {
    y=$1
    m=$2
    file=$3

    echo create_30 ${y} ${m} ${file}
    create_feb $1 $2 $3

    for d in 29 30 ; do
	echo "eis_daily_check, '/home/sbukeis/data/status/${y}/${m}/${d}/','/home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt'" >> ${file}
    done
}

function check_30 () {
    y=$1
    m=$2

    echo check_30 ${y} ${m}
    check_feb $1 $2

    for d in 29 30 ; do
	/bin/cat /home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt | awk -f '/home/sbukeis/src/add_range.awk' > /home/sbukeis/data/status/${y}/${m}/${d}/plots/${y}${m}${d}_check.txt
	/bin/rm /home/sbukeis/work/localdata/pipeline/plots/${y}${m}${d}_check.txt
    done
}

function create_31 () {
    y=$1
    m=$2
    file=$3
    d=31

    echo create_31 ${y} ${m} ${d} ${file}
    create_30 $1 $2 $3
    echo "eis_daily_check, '/home/sbukeis/data/status/${y}/${m}/31/','/home/sbukeis/work/localdata/pipeline/plots/${y}${m}31_check.txt'" >> ${file}
}

function check_31 () {
    y=$1
    m=$2
    d=31

    echo check_31 ${y} ${m}
    check_30 $1 $2

###    /bin/cat /home/sbukeis/work/localdata/pipeline/plots/${y}${m}31_check.txt | awk -f '/home/sbukeis/src/add_range.awk' > /home/sbukeis/data/status/${y}/${m}/${d}/plots/${y}${m}31_check.txt
    /bin/cat /home/sbukeis/work/localdata/pipeline/plots/${y}${m}31_check.txt | awk -f '/home/sbukeis/src/add_range.awk' > /home/sbukeis/data/status/${y}/${m}/31/plots/${y}${m}31_check.txt
    /bin/rm /home/sbukeis/work/localdata/pipeline/plots/${y}${m}31_check.txt
}
    
if [[ $# -eq 1 ]] ; then
    year=$1
    month=""
else
    if [[ $# -eq 2 ]] ; then
	year=$1
	month=$2
    else
	echo check_only1 yyyy [mm]
	exit 1
    fi
fi

if [[ -z "${month}" ]] ; then
    file=$$.pro
    for month in 01 02 03 04 05 06 07 08 09 10 11 12 ; do

	if [[ " 01 03 05 07 08 10 12 " == *" ${month} "* ]] ; then
	    create_31 ${year} ${month} ${file}
#	    echo "Running SSWIDL"
#	    csh -c sswidl < ./${file}
#	    check_31 ${year} ${month}
	else
	    if [[ " 04 06 09 11 " == *" ${month} "* ]] ; then
		create_30 ${year} ${month} ${file}
#		echo "Running SSWIDL"
#		csh -c sswidl < ./${file}
#		check_30 ${year} ${month}
	    else
		create_feb ${year} ${month} ${file}
#		echo "Running SSWIDL"
#		csh -c sswidl < ./${file}
#		check_feb ${year} ${month}
	    fi
	fi

    done

    echo "Running SSWIDL"
    csh -c sswidl < ./${file}
    /bin/rm ./${file}

    for month in 01 02 03 04 05 06 07 08 09 10 11 12 ; do
	if [[ " 01 03 05 07 08 10 12 " == *" ${month} "* ]] ; then
	    check_31 ${year} ${month}
	else
	    if [[ " 04 06 09 11 " == *" ${month} "* ]] ; then
		check_30 ${year} ${month}
	    else
		check_feb ${year} ${month}
	    fi
	fi
    done

else

    file=$$.pro

    if [[ " 01 03 05 07 08 10 12 " == *" ${month} "* ]] ; then
	create_31 ${year} ${month} ${file}
	echo "Running SSWIDL"
	csh -c sswidl < ./${file}
	check_31 ${year} ${month}
    else
	if [[ " 04 06 09 11 " == *" ${month} "* ]] ; then
	    create_30 ${year} ${month} ${file}
	    echo "Running SSWIDL"
	    csh -c sswidl < ./${file}
	    check_30 ${year} ${month}
	else
	    create_feb ${year} ${month} ${file}
	    echo "Running SSWIDL"
	    csh -c sswidl < ./${file}
	    check_feb ${year} ${month}
	fi
    fi
    
    /bin/rm ./${file}
fi

#./daily_merge_status1.pl CHECK_ONLY 20210301 20210302
