#!/bin/csh

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.csh
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#$HOME/bin/dr_list_cron

set src=~/eisco/../cp/cmdpln

set today=`date +"%Y%m%d"`
set archive=$today".tar.gz"

set year=`date +"%Y"`

if (-e $src/$today) then
    cp -r $src/$today ~/tmp
    (cd ~/tmp ; tar cvfz $archive $today ; mv $archive ~/data/staging/cmdpln/${year} ; rm -rf $today)
endif
