#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$db_dir    = "$HOME/work/localdata/database/timeline";
$db        = "timeline_raster";

dbmopen(%db, "$db_dir/$db.db", '0777') or die "Can't open database $db.db: $!";

while(<>) {
    chomp;
    @data = split;
    $junk = shift @data;
    $key = shift @data;
    # 1 st_id, 2 st_acr, 4 ra_id, 5 ra_acr, 6 start date, 7 start time, 8 end date, 9 end time, 10 duration, 11 type, 12 reps, 13 fov
    $line = join ' ', ($data[4], $data[5], $data[6], $data[7], $data[8], $data[9], $data[10], $data[11], $data[12], $data[13]);
    if(defined($db{$key})) {
	$string = join(' ', ($db{$key}));
	@string = split / /, $string;
	$raster_count = shift @string;
	++$raster_count;	# Incrememnt raster count
	unshift @string, ($raster_count);
	$new_string = join ' ', @string;
	print "Updated entry will be: $key -> [", $new_string . ' ' . $line, "]\n";
	$db{$key} = $new_string . ' ' . $line;
    }
    else {
	print "New entry will be: $key -> [1 $line]\n";
	$db{$key} = "1 " . $line;
    }
}

dbmclose %db;
