#!/usr/local/bin/sh

# The start time will either be passed in or will be generated from time now - 1 (days) (or maybe 2)

declare -i index

/bin/rm ~/work/localdata/sdtp/daily/eis_*

sdate=20061016	# Start date of telemetry
edate=20061017	# End date

# Start times
stimes='0000 0130 0300 0430 0600 0730 0900 1030 1200 1330 1500 1630 1800 1930 2100'

# End times
etimes=(0130 0300 0430 0600 0730 0900 1030 1200 1330 1500 1630 1800 1930 2100 2230)

# Index into end times array
set index=0

# Whizz through the start times array and fetch status telemetry
for start in $stimes ; do
    $HOME/bin/sdtp daily usc34 band=3 sdate=$sdate edate=$sdate stime=$start etime=${etimes[$((index))]}
    set index=$((++index))
done

# Last one uses the edate (next day)
$HOME/bin/sdtp daily usc34 band=3 sdate=$sdate edate=$edate stime=2230 etime=0000

## Now start the status fits reformatter
#print > ~/tmp/daily.pro <<EOF
#auto_mk_fits,'$HOME/localdata/sdtp/daily','$HOME/data/status/$darts_dir/'
#exit
#EOF
#system("sswidl < ~/tmp/daily_status.pro");
#
## Now do the daily plots
#print > ~/tmp/daily_plot.pro <<EOF
#eis_daily_plots,'$HOME/data/status/$darts_dir/','$HOME/tmp/','$end_date'
#exit
#EOF
#
## Now create pdf's out of the fits files
#system("$HOME/bin/daily_pdfs $HOME/tmp $HOME/data/status/$darts_dir/");
#
## Now gzip the fits data files
#system("gzip $HOME/data/status/$darts_dir/*");
#
## Now remove the trail of junk
#system("bin/rm $HOME/tmp/*pdf");
