#!/usr/bin/env perl
#
# start a bash shell
# cd to staging/reformat_summary/yyyy
#
# 1 arg: yyyymmdd
# Read files summary_yyyymmdd.txt and yyyymmdd_data_loss.txt, print out selected fields from both files.
#
# data_loss_estimate.pl 20190815 | awk -f ~/bin/data_loss_estimate_funnies.awk
# for f in $(ls summary*); do echo ${f} ; data_loss_estimate.pl ${f:8:8} | awk -f ${HOME}/bin/data_loss_estimate_funnies.awk; done | awk '/Fits/ {next} {print}' | sort -k 3
# for f in $(ls summary*); do echo ${f} ; data_loss_estimate.pl ${f:8:8} | awk -f ${HOME}/bin/data_loss_estimate_funnies.awk; done | awk '/Fits/ {next} /Total/ {next} /summary/ {next} {print}' | sort -k 3

# Number of files in all the summaries:
# for f in $(ls summary*); do  grep -c eis_md ${f}; done | awk '{sum += $1} END {print sum}'

usage() if $#ARGV ne 0;

my %summary_lines;
my %data_lines;

my $key;
my $md;
my $study_acr;
my $raster_acr;
my $ccsds;
my $ccsds_missing;
my $ccsds_gaps;
my $status;
my $tot_pix;
my $blank_pix;
my $percent;
my $comp;

my $date = shift;

my $file = "summary_" . "$date" . ".txt";
if (open(F, "<$file")) {
    while(<F>) {
        last if /^$/;
    }
    while(<F>) {
	last if /^$/;
    }
    while(<F>) {
        next if /Filename/;
        chomp;
	my @fields = split;
        my $k = $fields[13];
        $summary_lines{$k} = [@fields];
    }
    close F;
}
else {
    die "Can't open summary file: $!";
}

my $year = substr($date, 0, 4);
$file = $ENV{'HOME'} . "/data/staging/logs/data_loss/" . "$year" . "/" .  "$date" . "_data_loss.txt";
#print STDERR "FILE: $file\n";
if (open(F, "<$file")) {
    <F>;
    while(<F>) {
        chomp;
	my @fields = split;
        my $k = $fields[0];
        $data_lines{$k} = [@fields];
    }
    close F;
}
else {
    die "Can't open data loss file: $!";
}

foreach $k (sort keys %summary_lines) {
    $key = $k;
    $md            = $summary_lines{$k}[0];
    $study_acr     = $data_lines{$k}[1];
    $raster_acr    = $data_lines{$k}[2];
    $ccsds         = $summary_lines{$k}[9];
    $ccsds_missing = $summary_lines{$k}[10];
    $ccsds_gaps    = $summary_lines{$k}[11];
    $status        = $summary_lines{$k}[12];
    $tot_pix       = $data_lines{$k}[3];
    $blank_pix     = $data_lines{$k}[4];
    $percent       = $data_lines{$k}[5];
    $comp          = $data_lines{$k}[6];

    write STDOUT;
}

sub usage {
    print "1 argument in the form yyyymmdd required\n";
    die;
}

format STDOUT_TOP =                                                                                                         
@>>>>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>> @|||||||||| @|||||||||| @|||||||||| @>>>>>> @>>>>>>>>>>>> @>>>>>>>>>>>> @>>>>>>>@>>>>>>                            
"Fits file", "Source file", "Study Acronym", "Raster acronym", "ccsds rec", "ccsds lost", "ccsds gaps", "Status", "Total pix", "Blank pix", "Percent", "Comp"                                                                 
.                                                                                                                                                                                                                             

format STDOUT =                                                                                                                                                                                                               
@<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<< @>>>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>> @######### @########## @########## @>>>>>>> @############ @############ @####.##@>>>>>>                            
$key, $md, $study_acr, $raster_acr, $ccsds, $ccsds_missing, $ccsds_gaps, $status, $tot_pix, $blank_pix, $percent, $comp                                                                                                       
.                                                                                                                                                                                                                             

