# Read file from stdin. File format is that produced by data_loss_estimate.pl                                                                                                                                                 
#                                                                                                                                                                                                                             
# Flag lines where:                                                                                                                                                                                                           
#       blank pixels > 0 and ccsds lost == 0                                                                                                                                                                                  
#       ccsds lost > 0 and status == Ok                                                                                                                                                                                       
#                                                                                                                                                                                                                             
# Alternative: just flag up lines which have blank pixels but no missing ccsds packets.                                                                                                                                       
#                                                                                                                                                                                                                             
# Use -v summary=all to get both options. Leave blank to get first option.                                                                                                                                                    
#
BEGIN {
    hdr = 1
    bad = 0
    tot = 0
}

END {
    printf("Total: %u\tBad: %u\tPercent: %f\n", tot, bad, (bad / tot) * 100)
}

/^$/    { next }
/Fits/  { if (hdr) { print; hdr = 0; } }
	{ ++tot; if (summary == "all") {
		if ( (($10 > 0) && ($6 == 0)) || (($6 > 0) && ($8 == "Ok")) ) { ++bad; print }
	    }
	    else {
		if ( ($10 > 0) && ($6 == 0) ) { ++bad; print }
	    }
	}
