#!/usr/local/bin/perl -W

# Read in cpt or MSSL generated hex file, check it and interprete contents.

# dump_obstbl [-c] [seqnnn] [llnn] obstbl.hex

# Cmd id => ['cmd name', parameter length in bytes]
%cmds = ('44' => ['eis_cam_prog_csg_win ',  4],
         '45' => ['eis_cam_setup_ae     ',  8],
	 '54' => ['eis_mhc_motor_enable ',  2],
	 '5A' => ['eis_mhc_find_sht_ind ',  2],
	 '5F' => ['eis_mhc_auto_safe    ',  6],
	 '62' => ['eis_mhc_mir_f_auto   ',  6],
	 '65' => ['eis_mhc_cal_src_ctl  ',  6],
         '66' => ['eis_mhc_cal_power    ',  6],
	 '69' => ['eis_mhc_heater_off   ',  6],
	 '6A' => ['eis_mhc_heater_on    ',  6],
         '6F' => ['eis_mhc_parameter_set',  8],
	 '70' => ['eis_mhc_qcm_ctl      ',  8],
	 '71' => ['eis_mhc_qcm_htr      ',  6],
	 '73' => ['eis_slit_slot_auto   ',  8],
	 '74' => ['eis_slit_slot_manual ',  8],
	 '76' => ['eis_mhc_watchdog     ',  6],
         '81' => ['eis_stop_seq         ',  1],
         '82' => ['eis_call_seq         ',  1],
         '85' => ['eis_flush_ccd        ',  2],
         '86' => ['eis_run_raster       ', 22],
	 '87' => ['eis_set_mhc_opepar   ', 36],
         '89' => ['eis_set_seq_loop     ',  1],
         '8A' => ['eis_delay            ',  2],
         '8D' => ['eis_start_exp        ',  2],
         '8E' => ['eis_flat_field       ',  3],
         );

@slit_slot = ('1"', '256"', '2"', '40"');

$cpt = 0;

# $argc will be 0 for prog + filename
$argc = $#ARGV;
if($argc > 0) {
    while($argc--) {
	$a = shift;

	print "A = $a\n";
	if($a =~ /-c/) {
#	    print "FOUND -c\n";
	    $cpt = 1;
	}

	if($a =~ /seq/) {
#	    print "SEQ FOUND : $a\n";
	    $qseq = $a;
	    print "QSEQ = $qseq\n";
	}
	if($a =~ /ll/) {
#	    print "LL FOUND : $a\n";
	    $qll = $a;
	}
    }
}

#$c=<>;	# First line is comment line
#print "$c";

$info = <>;	# Address etc
chop $info;

$sequence = "";
while(<>) {
    chop;
    $len = length $_;
    $sequence .= substr($_, 9, ($len - 11));
}

&decode_sequence($sequence);

exit;

#if($cpt == 1) {
#    foreach $seq (0..127) {
#	$seqs[$seq] = <>;
#    }
#    foreach $ll (0..47) {
#	$lls[$ll] = <>;
#	chop $lls[$ll];
#	$foo = <>;
#	chop $foo;
#	$len_foo = length($foo);
#	$lls[$ll] .= substr($foo, 9, ($len_foo - 9));
#    }
#}
#else {
#    foreach $seq (0..127) {
#	foreach $i (0..4) {
#	    $line = <>;
#	    chomp $line;
#	    $len = length $line;
#	    if($i == 0) {
#		$seq_line = $line;
#	    }
#	    else {
#		$seq_line = substr $line, 9, $len - 9;
#	    }
#	    chop $seq_line;
#	    chop $seq_line;
#	    $seqs[$seq] .= $seq_line;
#	}
#	$junk = <>;	# Address line of next sequence
#    }
#    # Address line has already been read
#    foreach $ll (0..47) {
#	foreach $i (0..5) {
#	    $line = <>;
#	    chomp $line;
#	    $len = length $line;
#	    if($i == 0) {
#		$ll_line = $line;
#	    }
#	    else {
#		$ll_line = substr $line, 9, $len - 9;
#	    }
#	    chop $ll_line;
#	    chop $ll_line;
#	    $lls[$ll] .= $ll_line;
#	}
#	$junk = <>;	# Address line of next line list
#    }
#}

#foreach $i (0..127) {
#    print "SEQ[$i] = ", $seqs[$i], "\n";
#}

#foreach $i (0..47) {
#    print "LL[$i] = ", $lls[$i], "\n";
#}

if($qseq) {
    $qseq =~ s/seq//;
    $l = length($seqs[$qseq]);
    $sequence = substr($seqs[$qseq], 9, ($l - 9));
    &decode_sequence($qseq, $sequence);
}
else {
    if(!$qll) {
	foreach $seq (0..127) {
	    $l = length($seqs[$seq]);
	    $sequence = substr($seqs[$seq], 9, ($l - 9));
	    &decode_sequence($seq, $sequence);
	}
    }
}

if($qll) {
    $qll =~ s/ll//;
    $l = length($lls[$qll]);
    $linelist = substr($lls[$qll], 9, ($l - 9));
    &decode_linelist($qll, $linelist);
}
else {
    if(!$qseq) {
	foreach $ll (0..47) {
	    $l = length($lls[$ll]);
	    $linelist = substr($lls[$ll], 9, ($l - 9));
	    &decode_linelist($ll, $linelist);
	}
    }
}

sub decode_sequence {
#    my $snum = shift;
    my $seq = shift;

###    print "DECODE: seq = $seq\n";
#    return;

#    chop $seq;

    $len = sprintf "%03u", hex(byte(0, $seq));
#    print "\nSEQUENCE $snum";
    if($len > 128) {
	print "\tUNUSED\n";
	return;
    }
    print "\n0\tLENGTH\t\t\t$len\n";
    print "1\tSEQID\t\t\t", word(1, $seq), "\n";
    print "3\tSEQ REP\t\t\t", byte(3, $seq), "\n";

    $cmd_offset = 4;
    $cmd = 0;
###    while( ($cmd ne '81') && ($cmd ne '82')) {
    while(1) {
        $cmd = byte($cmd_offset, $seq);
	last if $cmd_offset > $len;
	if(defined($cmds{$cmd})) {
	    print "$cmd_offset\t", $cmds{$cmd}[0], "\t", bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq), "\n";

            if($cmds{$cmd}[0] eq 'eis_run_raster       ') {
                decode_run_raster(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
            }
	    elsif($cmds{$cmd}[0] eq 'eis_slit_slot_auto   ') {
		decode_slitslot_auto(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
	    }
	    $cmd_offset += ($cmds{$cmd}[1] + 1);
	}
        else {
            if($cmd_offset == ($len - 1)) {
		
                print "$cmd_offset\tCHECKSUM\t\t$cmd\n";
		last;
            }
            else {
                print "$cmd_offset\t??????\t\t\t$cmd\n";
            }
            ++$cmd_offset;
        }
	
    }
}

sub decode_linelist {
    my $snum = shift;
    my $mem_str = shift;

    print "\nLINE LIST $snum";

    chop $mem_str;

    $len = sprintf "%u", hex(byte(0, $mem_str));
    if(($len == 0) || ($len == 255)) {
	print " Unused\n";
	return;
#	print "Incorrect length ($len)\n";
#	exit -2;
    }
    print "\n";

    print "0\tLinelist length\t\t$len\n";
    $nwin = sprintf "%u", hex(byte(2, $mem_str));
    if(($len == 0) || ($nwin > 25)) {
	print "Incorrect nwin ($nwin)\n";
	exit -2;
    }
    print "2\tNumber of sw windows\t", byte(2, $mem_str), "\n";
    print "3\tChecksum\t\t", sprintf("%02X", hex(byte(3,$mem_str))), "\n";
    print "4\tCCD Length\t\t", word(4, $mem_str), "\n";
    print "6\tXws\t\t\t", word(6, $mem_str), "\n";
    print "8\tXw\t\t\t", word(8, $mem_str), "\n";
    print "10\tYws\t\t\t", word(10, $mem_str), "\n";
    print "12\tYw\t\t\t", word(12, $mem_str), "\n";

    $offset = 14;
    for($i = 0; $i < $nwin; ++$i) {
	$tabs = 2;
	$tabs = 1 unless $i < 10;
	print "$offset\tSW $i Hdr, Xs, X", "\t" x $tabs, word($offset, $mem_str);
	$offset += 2;

	print ", ", word($offset, $mem_str);

	$offset += 2;
	print ", ", word($offset, $mem_str), "\n";
	$offset += 2;
    }
}

sub decode_run_raster {
    my $bytes = shift;

    print "\t\t\t\tRaster ID\t", word(1, $bytes), "\n";
    print "\t\t\t\tMip\t\t", word(3, $bytes), "\n";
    print "\t\t\t\tLoop Counter\t", word(5, $bytes), "\n";
    print "\t\t\t\tCompression\t", word(7, $bytes), "\n";
    print "\t\t\t\tOCB-X\t\t", byte(9, $bytes), "\n";
    print "\t\t\t\tOCB-Y\t\t", byte(10, $bytes), "\n";
    print "\t\t\t\tFlush Id\t", byte(11, $bytes), "\n";
    print "\t\t\t\tNum flush\t", byte(12, $bytes), "\n";
    print "\t\t\t\tExp/pos\t\t", sprintf("%02u", hex(byte(13, $bytes))) & 0xF, "\n";
    print "\t\t\t\tASRC ctl\t", byte(14, $bytes), "\n";
    $ro = sprintf("%u", hex(byte(15, $bytes)));
    $ro >>= 4;
    print "\t\t\t\tRo nodes\t", sprintf("%02X", $ro), "\n";
 
    $foo = sprintf("%u", hex(byte(15, $bytes)));
    $foo &= 0x0F;
    $foo <<= 8;
 
    $foo1 = sprintf("%u", hex(byte(16, $bytes)));
    $bar = sprintf("%04X", ($foo | $foo1));
 
    print "\t\t\t\tRepeats\t\t$bar\n";

    print "\t\t\t\tASRC skip\t", byte(17, $bytes), "\n";
    print "\t\t\t\tRo seq\t\t", byte(18, $bytes), "\n";
    print "\t\t\t\tStep size\t", word(19, $bytes), "\n";
    print "\t\t\t\tLine list\t", byte(21, $bytes), "\n";
    print "\t\t\t\tSci Op\t\t", byte(22, $bytes), "\n";
}


sub decode_slitslot_auto {
    my $bytes = shift;

    my $dir = word(5, $bytes);
    my $s   = word(7, $bytes);
    my $dir_str;
    my $s_str;

    $dir_str = " (forward)";
    $dir_str = " (reverse)" unless $dir == 1;
    my $foo = sprintf("%u", $s);
    $s_str = $slit_slot[$foo];
    print "\t\t\t\tDirection\t", word(5, $bytes), "$dir_str\n";
    print "\t\t\t\tSlit\t\t", word(7, $bytes), " ($s_str)\n";
}

sub bytes {
    my $offset = shift;
    my $len    = shift;
    my $str    = shift;
    return substr $str, ($offset * 2), ($len * 2);
}
 
sub byte {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 2;
}
 
sub word {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 4;
}
