#!/usr/bin/env perl

=pod

#title
The EIS science2 database : Version 0.1 02/01/2005

#maxentries
500000

#items
SN_ID               I*4      sequence ID associated with this entry
RA_INDEX            I*2      index to raster in this science entry
RA_ID               I*4      raster ID (for this raster)
RA_REPEATS          I*2      number of repeats (for this raster)
RA_NWINDOWS         I*2      number of data windows (etc.)
RA_COMPRESSION      B*1      compression factor
RA_DURATION         I*8      duration in ms
RA_VOLUME           I*8      volume in pixels
RA_AEC_FLG(25)      B*1      line flagged for AEC
RA_AEC_PROPS(6)     I*4
RA_EIS_FLR_FLG(25)  B*1      line flagged for detecting EIS flares
RA_EIS_FLR_PROPS(6) I*4
RA_EIS_EVT_FLG(25)  B*1      line flagged for detecting EIS events
RA_EIS_EVT_PROPS(4) I*4
RA_XRT_PROPS        I*4      (respond to) XRT flare
ASRC_ENABLED        B*1      Anti-spacecraft Roll enabled/disabled
ASRC_DIRECTION      B*1      ASCR direction (0/1 = forward/backward)
ASRC_SKIP           B*1      ASCR direction (1/2)
ASRC_NSTEPS         I*4      ASCR number of compensation steps
MIP                 I*4      Miror Initial Position
YIP                 I*4      Where software window starts
X_POINT             R*8      EIS Pointing X-Coordinate
Y_POINT             R*8      EIS Pointing X-Coordinate
CMP                 I*2      Coarse Mirror Position
RA_START_TIME       R*8      Raster Start Time (TAI)
RA_STOP_TIME        R*8      Raster Stop Time  (TAI)
SC_X                R*8      Spacecraft Pointing X-Coordinate
SC_Y                R*8      Spacecraft Pointing X-Coordinate

#index
SN_ID          index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $science_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/timeline_db/eis_science2_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $science_db: $!" unless sysopen(DB, $science_db, O_RDONLY);

my $format = "NNnNnnCNNNNC25N6C25N6C25N4NCCCNNNNNNNnNNNNNNNNN";

# Read 928 bytes of junk at start
my $num_read = sysread DB, $buffer, 244;

while (1) {
    
    $num_read = sysread DB, $buffer, 244;
    last if $num_read == 0;

    my ($en,$id,$in,$rid,$rep,$nwin,$comp,$durms,$durls,$volms,$volls,$g,$g1,$g2,$g3,$g4,$g5,$g6,$g7,$g8,$g9,$g10,$g11,$g12,$g13,$g14,$g15,$g16,$g17,$g18,$g19,$g20,$g21,$g22,$g23,$g24,$fp,$fp1,$fp2,$fp3,$fp4,$fp5,$f,$f1,$f2,$f3,$f4,$f5,$f6,$f7,$f8,$f9,$f10,$f11,$f12,$f13,$f14,$f15,$f16,$f17,$f18,$f19,$f20,$f21,$f22,$f23,$f24,$pp,$pp1,$pp2,$pp3,$pp4,$pp5,$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$e8,$e9,$e10,$e11,$e12,$e13,$e14,$e15,$e16,$e17,$e18,$e19,$e20,$e21,$e22,$e23,$e24,$ep,$ep1,$ep2,$ep3,$x,$a,$a1,$a2,$a3,$m,$y,$xms,$xls,$yms,$yls,$cmp,$sms,$sls,$tms,$tls,$scxms,$scxls,$scyms,$scyls,$in1) = unpack $format, $buffer;

    print "$en|$id|$in|$rid|$rep|$nwin|$comp|$durms|$durls|$volms|$volls|[$g,$g1,$g2,$g3,$g4,$g5,$g6,$g7,$g8,$g9,$g10,$g11,$g12,$g13,$g14,$g15,$g16,$g17,$g18,$g19,$g20,$g21,$g22,$g23,$g24]|[$fp,$fp1,$fp2,$fp3,$fp4,$fp5]|[$f,$f1,$f2,$f3,$f4,$f5,$f6,$f7,$f8,$f9,$f10,$f11,$f12,$f13,$f14,$f15,$f16,$f17,$f18,$f19,$f20,$f21,$f22,$f23,$f24]|[$pp,$pp1,$pp2,$pp3,$pp4,$pp5]|[$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$e8,$e9,$e10,$e11,$e12,$e13,$e14,$e15,$e16,$e17,$e18,$e19,$e20,$e21,$e22,$e23,$e24]|[$ep,$ep1,$ep2,$ep3]|$x|$a|$a1|$a2|$a3|$m|$y|$xms|$xls|$yms|$yls|$cmp|$sms|$sls|$tms|$tls|$scxms|$scxls|$scyms|$scyls\n";
}

close DB;

