#!/usr/bin/env perl

=pod

#title
The EIS science activities database : Version 0.1 02/01/2005
DURATION changed to ms June 2005

#maxentries
500000

#itemsN
    ID              I*4      ID associated with this entryN
    SOLARB_SCI      C*80     Solar-B science associated with this entryA80
    OBS_ID          I*2      Sequential number of observationn
    JOP_ID          I*2n
    OBSERVER        C*30     Name of the Chief ObserverA30
    PLANNER         C*30     Name of the Chief PlannerA30
    TOHBANS(2)      C*30     Name of the KSC TohbansA30
    OBSTITLE        C*80     Title of the observationA80
    SCI_OBJ         C*80     Target phenomenon (selected from a list)A80
    OBS_DEC         C*80     Properties of the observationA80
    JOIN_SB         C*10     Indicates joint observationA10
    NOAA_NUM        I*4N
    EIS_SCI         C*80     EIS science associated with this entryA80
    CAMPAIGN        C*80     Campaign details associated with this entryA80
    NOTES           C*80     Notes for this entryA80
    DISTURBANCE     C*80     Any special disturbance associated with this entryA80
    TARGET          C*20     Specific Target for this entryA20
    TARGET_ID       C*20     Target ID (Active region ID etc.)A20
    STUDY_ID        I*4      Study ID for this entryN
    N_REPEATS       I*2      Number of times to repeat this studyn
    DURATION        I*8      Science entry duration (milli seconds)N2
    DATA_VOLUME     I*8      Science entry data volume (units TBD)N2
    N_RASTERS       I*2      Number of rasters in this study entryn
    SLIT_SLOT(3)    I*2      Used to track slit/slot movementsn3
    AEC_RESPONSE    I*4      response parameters for AECN
    EIS_FLR_RES(5)  I*4
    EIS_EVT_RES(5)  I*4
    XRT_FLR_RES(7)  I*4
#index
ID              index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $science_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/timeline_db/eis_science_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $science_db: $!" unless sysopen(DB, $science_db, O_RDONLY);

my $format = "NNA80nnA30A30A60A80A80A80A10NA80A80A80A80A20A20NnNNNNnnnnNNNNNNNNNNNNNNNNNNN";

# Read 928 bytes of junk at start
my $num_read = sysread DB, $buffer, 928;

while (1) {
    
    $num_read = sysread DB, $buffer, 928;
    last if $num_read == 0;

    my ($en,$id,$sci,$obsid,$jop,$obs,$pl,$to,$obst,$obj,$dec,$join,$noaa,$esci,$cam,$nb,$dist,$t,$tid,$sid,$rep,$durms,$durls,,$volms,$volls,$nr,$ss1,$ss2,$ss3,$aec,$ef1,$ef2,$ef3,$ef4,$ef5,$evt1,$evt2,$evt3,$evt4,$evt5,$x1,$x2,$x3,$x4,$x5,$x6,$x7,$in) = unpack $format, $buffer;
    print "$en|$id|'$sci'|$obsid|$jop|'$obs'|'$p'|'$to'|'$obst'|'$obj'|'$dec'|'$join'|$noaa|'$esci'|'$cam'|'$nb'|'$dist'|'$t'|'$tid'|$sid|$rep|$durms|$durls|$volms|$volls|$nr|[$ss1,$ss2,$ss3]|$aec|[$ef1,$ef2,$ef3,$ef4,$ef5]|[$evt1,$evt2,$evt3,$evt4,$evt5]|[$x1,$x2,$x3,$x4,$x5,$x6,$x7]\n";
}

close DB;

# 66577|66577|''|2|0|'Kyoko Watanabe'|''|'Yoshitake'|'synoptic'|'SYN'|'synoptic'|'E,S,X'|0|''|''|''|'10.0,20.0'|'Quiet Sun'|''|494|1|0|34965|0|537810|1|[0,1,1]|0|[0,0,0,0,0]|[0,0,0,0,0,0,0,0,0,0,0,0]|
