#!/usr/bin/env perl

=pod

#title
The EIS timeline response studies database : Version 0.1 02/01/2005

#maxentries
500000

#items
ID              I*4      ID associated with this entry
TRIG_ST_SEQID   I*4      Seq_id of Trigger (Parent) study
EEBP_RESPOND    B*1      Flag indicates a Bright Point response study
XRTF_RESPOND    B*1      Flag indicates an XRT Flare response study
EISF_RESPOND    B*1      Flag indicates an EIS Flare response study
AECE_RESPOND    B*1      Flag indicates an AEC response study
X_THRESHOLD     I*8      Threshold for the event line x-direction
Y_THRESHOLD     I*8      Threshold for the event line y-direction
X_MIN_LIMIT     I*4      If number of consecutive samples is greater, then trigger
Y_MIN_LIMIT     I*4      If number of consecutive samples is greater, then trigger
ADJUST_X        I*4      Flag to adjust pointing in x-direction
ADJUST_Y        I*4      Flag to adjust pointing in y-direction
LOCATE_X        I*4      Flag indicating to use flare peak/centre (0/1)
LOCATE_Y        I*4      Flag indicating to use flare peak/centre (0/1)
RESPONSE_ST_ID  I*4      ID of response study (in study database)
RESPONSE_RA_ID  I*4      ID of response raster (in raster database)
LINE_INDEX      I*4      Index of selected line in selected repoint raster
FILLER_ST_ID    I*4      ID of filler study (in study database)
TYPE            C*4      entry type. One of EEBP/XRTF/EISF/AECE
CREATED         R*8      Date/time when entry was added to DB
MODIFIED        R*8      Date/time when entry was last updated
NO_HUNT_DATA    B*1      Flag indicating data download
RA1_XCEN        R*8      EIS Pointing X-Coordinate
RA1_YCEN        R*8      EIS Pointing Y-Coordinate
RA1_MIP         I*4      Mirror Initial Position
RA1_YIP         I*4      Where software window starts
RA1_SC_X        R*8      Spacecraft Pointing X-Coordinate
RA1_SC_Y        R*8      Spacecraft Pointing Y-Coordinate
RA1_POINTED     B*1      Flag indicating ra1 was pointed by planner
RA2_USE         B*1      Flag indicating whether to use pointing for ra_2
RA2_XCEN        R*8      EIS Pointing X-Coordinate
RA2_YCEN        R*8      EIS Pointing Y-Coordinate
RA2_MIP         I*4      Miror Initial Position
RA2_YIP         I*4      Where software window starts
RA2_SC_X        R*8      Spacecraft Pointing X-Coordinate
RA2_SC_Y        R*8      Spacecraft Pointing Y-Coordinate
START_TIME      R*8      start time for this plan entry (tai)
STOP_TIME       R*8      end time for this plan entry (tai)
ST_ID           I*4      Study ID
NOTE_1          C*20     Note
NOTE_2          C*20     Note
SPARE_INT_1     I*4      Spare integer tag
SPARE_INT_2     I*4      Another spare integer tag
SPARE_LONG_1    I*8      Spare long integer tag
SPARE_LONG_2    I*8      Another spare long integer tag
SPARE_FLAG_1    B*1      Spare Flag
SPARE_FLAG_2    B*1      Another Spare Flag
SPARE_DBL_1     R*8      Spare DBL tag
SPARE_DBL_2     R*8      Another spare DBL tag

#index
TRIG_ST_SEQID   index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $tl_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/timeline_db/eis_tl_response_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $tl_db: $!" unless sysopen(DB, $tl_db, O_RDONLY);

my $format = "NNNCCCCNNNNNNNNNNNNNNA4NNNNCNNNNNNNNNNCCNNNNNNNNNNNNNNNA20A20NNNNNNCCNNNNN";

# Read  bytes of junk at start
my $num_read = sysread DB, $buffer, 280;

while (1) {
    
    $num_read = sysread DB, $buffer, 280;
    last if $num_read == 0;

    my ($en,$id,$n,$b,$b1,$b2,$b3,$ims,$ils,$i1ms,$i1ls,$n1,$n2,$n3,$n4,$n5,$n6,$n7,$n8,$n9,$n10,$c4,$rms,$rls,$r1ms,$r1ls,$b4,$r2ms,$r2ls,$r3ms,$r3ls,$i,$i1,$r4ms,$r4ls,$r5ms,$r5ls,$b5,$b6,$r6ms,$r6ls,$r7ms,$r7ls,$i2,$i3,$r8ms,$r8ls,$r9ms,$r9ls,$r10ms,$r10ls,$r11ms,$r11ls,$i4,$nb1,$nb2,$sp,$sp1,$sp2,$sp3,$sp4,$sp5,$sp6,$sp7,$id1) = unpack $format, $buffer;

    print "$en|$id|$n|$b|$b1|$b2|$b3|$ims|$ils|$i1ms|$i1ls|$n1|$n2|$n3|$n4|$n5|$n6|$n7|$n8|$n9|$n10|'$c4'|$rms|$rls|$r1ms|$r1ls|$b4|$r2ms|$r2ls|$r3ms|$r3ls|$i|$i1|$r4ms|$r4ls|$r5ms|$r5ls|$b5|$b6|$r6ms|$r6ls|$r7ms|$r7ls|$i2|$i3|$r8ms|$r8ls|$r9ms|$r9ls|$r10ms|$r10ls|$r11ms|$r11ls|$i4|'$nb1'|'$nb2'|$sp|$sp1|$sp2|$sp3|$sp4|$sp5|$sp6|$sp7|$id1\n";
}

close DB;

#796|796|36184|1|0|0|0|0|5000|0|286720|7|1|1|1|0|0|444|421|0|0|'EEBP'|1104988713|1027604480|1104988713|1027604480|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|''|''|0|0|0|0|0|0|0|0|0
