#!/usr/bin/env perl

=pod

#title
The EIS engineering activities database : Version 0.1 02/01/2005

#maxentries
500000

#itemsN
    ID              I*4      sequence ID associated with this entryn
    ACRONYM         C*20     acronym (user supplied)A20
    TITLE           C*100    title (computer generated)A100
    ENG_FILE        C*80     engineering filename for this sequenceA80
    DESC_FILE       C*20     name of text file containing ASCII study descriptionA20
    NOTES           C*160    notes - added by plannerA160
    DURATION        R*8      engineering entry duration (seconds)N2
    DATA_VOLUME     R*4      engineering entry data volume (units TBD)N

#index
ID              index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $raster_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/technical_db/eis_engineering_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $raster_db: $!" unless sysopen(DB, $raster_db, O_RDONLY);

my $format;

if ($comma_delimit_lists) {
    $format = "NnA20A100A80A20A160N2N";
}
else {
    $format = "NC20C100C80C20C160N2N";
}

# Read 0x194 bytes of junk at start
my $num_read = sysread DB, $buffer, 0x194;

while (1) {
    
    $num_read = sysread DB, $buffer, 404;
    last if $num_read == 0;
    
    if ($comma_delimit_lists) {
	my ($en,$id,$wl,$acr,$ti,$au,$da,$rt,$scns,$scss,$snns,$sndu,$ll,$nw,$w,$w1,$w2,$w3,$w4,$w5,$w6,$w7,$w8,$w9,$w10,$w11,$w12,$w13,$w14,$w15,$w16,$w17,$w18,$w19,$w20,$w21,$w22,$w23,$w24,$ht,$wi,$sla,$nexp,$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$d,$d1,$d2,$d3,$d4,$d5,$d6,$d7,$co,$sp,$radums,$raduls,$ravolms,$ravolls) = unpack $format, $buffer;
	my $radu = sprintf "%lu", $radums + $raduls;
	my $ravol = sprintf "%lu", $ravolms + $ravolls;
	print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$rt|$scns|$scss|$snns|$sndu|$ll|$nw|[$w,$w1,$w2,$w3,$w4,$w5,$w6,$w7,$w8,$w9,$w10,$w11,$w12,$w13,$w14,$w15,$w16,$w17,$w18,$w19,$w20,$w21,$w22,$w23,$w24]|$ht|$wi|$sla|$nexp|[$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7]|[$d,$d1,$d2,$d3,$d4,$d5,$d6,$d7]|$co|$sp|$radu|$ravol\n";
    }
    else {
	###my ($en, $id, $wl, $acr, $ti, $au, $da, $rt, $scns, $scss, $snns, $sndu, $ll, $nw, @win) = unpack "NNCA20A160A20A30CNNNNNnn25", $buffer;
	my ($en, $id, $acr, $ti, $eng_file, $desc_file, $notes, $duration, $data_volume) = unpack $format, $buffer;
	#my ($ht, $wi, $sla, $nexp, @exp) = unpack "x312nnnnN8", $buffer;
	#my (@del) = unpack "x352N8", $buffer;
	#my ($co, $sp, $radums, $raduls, $ravolms, $ravolls) = unpack "x384nnNNNN", $buffer;
	#my $radu = sprintf "%lu", $radums + $raduls;
	#my $ravol = sprintf "%lu", $ravolms + $ravolls;
	#print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$rt|$scns|$scss|$snns|$sndu|$ll|$nw|[@win]|$ht|$wi|$sla|$nexp|[@exp]|[@del]|$co|$sp|$radu|$ravol\n";
	print "$en|$id|'$acr'|'$ti'|'$eng_file'|'$desc_file'|'$notes'|$duration|$data_volume\n";
    }
}

close DB;

sub commafy_list {
    my $list_ref = shift;
    my @list;
    foreach my $element (@$list_ref) {
	push @list, "$element,";
    }
    chop $list[-1];
    #    print "@list\n";
    @$list_ref = @list;
    #    my @list = `sed 's/ /,/g' @$list_ref`;
    ###    print "COMMAFY (@list)\n";
    #    print "COMMAFY (\@list)\n";
}
