#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

#use NDBM_File;

$src_dir = "$HOME/data/staging/logs/md_translation";
$db_dir  = "$HOME/work/localdata/database";

dbmopen(%ra_db,  "$db_dir/raster/rasters.db", '0444') or die "Can't open raster database: $!";
#dbmopen(%exp_db, "$db_dir/exposure/exposures_2006.db", '0444') or die "Can't open raster database: $!";

foreach $year (2006 .. 2008) {
    print "YEAR: $year\n";
    while(($key, $val) = each %ra_db) {
	@record = split / /, $val;
	print "Id $key, ", $record[0], ", ", $record[2], " exposures per raster\n";

	dbmopen(%exp_db, "$db_dir/exposure/exposures_$year.db", '0444') or die "Can't open exposures_$year database: $!";
	while(($ekey, $val) = each %exp_db) {
	    @exp = split / /, $val;
	    $id = sprintf "%u", $exp[5];
#	    if($exp[5] == $key) {
	    if($id == $key) {
#		print "$val\n";
		@items = split / /, $val;
		print $items[0], " ", $items[1], "\t", $items[9], " ", $items[11], " ", $items[12], " " ,$items[13], " ", $items[14], "\t$id", "\n";;
	    }
	}
	dbmclose %exp_db;
	print "\n";
    }
    print "\n";

}
dbmclose %ra_db;

