#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$tmp_dir    = "$HOME/tmp/tmp";
$dest_dir   = "$HOME/tmp/raster_summaries";
$src_file   = "$HOME/tmp/all_summary_";

open(RDB, "< $HOME/tmp/raster_db_dump.txt") or die "Can't open raster database: $!";
while(<RDB>) {
    next if /[ ]+Id/;
    chomp;
    @line = split;
    $key = shift @line;
    $line = join ' ', @line;
    $rdb{$key} = $line;
#    print "[$key] -> [$line]\n";
}

close RDB;

foreach $raster (sort keys %rdb) {
    @items = split / /, $rdb{$raster};
    $acr = $items[0];
    $first = 1;
#    print "Acronym = [$acr]\n";
#    next;
    print "Processing $acr\n";
    foreach $year (2006 .. 2008) {
	foreach $month ('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12') {
###	    print "Doing $year$month for $acr\n";
	    if(-e "$src_file" . "$year$month" . ".txt") {
		$redirect = ">>";
		$redirect = ">" if $first;
		$first = 0;
		$string = "grep -h '$acr ' $HOME/tmp/all_summary_$year$month.txt | awk -f $HOME/bin/ratio.awk yyyymm=$year$month $redirect $tmp_dir/" . "$acr" . "_summary.txt";
#		$string = "grep -h $acr $HOME/tmp/all_summary_$year$month.txt | awk -f $HOME/bin/ratio.awk yyyymm=$year$month";
		$string =~ s/\"/\\"/g;
#		print "$string\n";
		system("$string");
	    }
	}
    }
}

#@files = `cd $tmp_dir && ls`;
#if(@files) {
#    foreach $f (@files) {
#	system("awk -f $HOME/bin/label.awk $tmp_dir/$f > $dest_dir/$f");
##	print "awk -f $HOME/bin/label.awk $tmp_dir/$f > $dest_dir/$f\n";
#    }
#}

