#!/usr/local/bin/perl

use File::Basename;
use Compress::Zlib;
use integer;

my %comp_fac = ('0x3B28' => 'DPCM',
		'0x3F28' => 'jpeg98',
		'0x3F2C' => 'jpeg95',
		'0x3F2D' => 'jpeg92',
		'0x3F29' => 'jpeg90',
		'0x3F2E' => 'jpeg85',
		'0x3F2A' => 'jpeg75',
		'0x3F2F' => 'jpeg65',
		'0x3F2B' => 'jpeg50'
		);

my %comeng_rasters = (
		      2324 => '914',
		      2323 => '913',
		      2305 => '901',
		      2306 => '902',
		      2307 => '903',
		      2308 => '904',
		      2309 => '905',
		      );

my %comcal_seqs = (
		   123 => '039',
		   124 => '038',
		   125 => '037',
		   126 => '036',
		   127 => '073',
		   1   => '074',
		   2   => '075',
		   3   => '068',
		   4   => '070',
		   5   => '901',
		   6   => '913',
		   7   => '914',
		   8   => '064',
		   9   => '066',
		   10  => '069',
		   11  => '071',
		   );

my %trans;
my %header = ();
my %card_image;

my $has_extension = 0;

print "Filename (.fits)         TLID STID        STUDY ACRONYM  RAID       RASTER ACRONYM         TARGET     COMP           START TIME             END TIME     DURATION DONE  REQ       XCEN       YCEN                          ST_AUTHOR    TIME (s)    Amin    Amax    Bmin    Bmax RA_AUTHOR\n";

foreach my $filename (@ARGV) {
    my $buffer;

    my $gzf = gzopen($filename, "rb") or die "Can't gzopen $filename: $gzerro\n";
    my $fname = basename($filename);
    $fname =~ s/\.gz//;

    $fname1=$fname;
#?    open(IN, "<$fname1") or die "Can't open $fname1: $!";
#    open(IN, "<$filename") or die "Can't open $filename: $!";
    $fname = substr $fname, -27, 22;

    my $going = 1;
    while($going) {
	$bytes_read = $gzf->gzread($buffer, 2880);
#	$bytes_read = sysread(IN,$buffer, 2880);
	for($i = 0; $i < 36; ++$i) {
	    $record = substr($buffer, 80 * $i, 80);
	    ($keyword, $rest) = split '=', $record;
	    $keyword =~ s/ //g;
	    next if $keyword =~ /^COMMENT/;
	    next if $keyword =~ /^CONTINUE/;
	    ($value, $comment) = split '/', $rest;
	    $value =~ s/\'//g;
	    $value =~ s/^ //;
#	    $value =~ s/[ ]*//;
	    $value =~ s/[ ]{2,}//;
	    $value =~ s/[ ]+$//;
	    if($keyword =~ /^END/) {
		$going = 0;
		last;
	    }
	    $has_extension = 1 if $record =~ /^EXTEND  =                    T/;
	    $card_image{$keyword} = $value;
	}
    }
    $card_image{"filename"} = $fname;
#    %{$header{"Primary"}} = %card_image;
    %{$header{"Primary"}} = %card_image;
    %card_image = ();
#    foreach my $k (sort keys %header) {
#	print "key = $k, val = ", $header{$k}, "\n";
#    }

    if($has_extension) {
	$going = 1;
	while($going) {
	    $bytes_read = $gzf->gzread($buffer, 2880);
#	    $bytes_read = sysread(IN, $buffer, 2880);
	    for($i = 0; $i < 36; ++$i) {
		$record = substr($buffer, 80 * $i, 80);
		($keyword, $rest) = split '=', $record;
		$keyword =~ s/ //g;
		next if $keyword =~ /^COMMENT/;
		next if $keyword =~ /^CONTINUE/;
		($value, $comment) = split '/', $rest;
		$value =~ s/\'//g;
		$value =~ s/^ //;
#		$value =~ s/[ ]*//;
		$value =~ s/[ ]{2,}//;
		$value =~ s/[ ]+$//;
		if($keyword =~ /^END/) {
		    $going = 0;
		    last;
		}
		$header_name = $value if $keyword =~ /^EXTNAME/;
		$card_image{$keyword} = $value;
	    }
	}
	$header_name =~ s/\'//g;
	$header_name =~ s/ //g;
	%{$header{$header_name}} = %card_image;
#    foreach my $k (sort keys %header) {
#	print "key = $k, val = ", $header{$k}, "\n";
#    }
    }
    $gzf->gzclose();
#    close IN;
    dump_hdr(\%header);
}
print "\n";


sub value_for_key {
    my $ref = shift;
    my $hdr = shift;
    my $key = shift;

    # mcrw 20200518 previous dict reference access syntax deprecated
    my %foo = %{$ref};
    return $foo{$hdr}{$key};
###    return %$ref->{$hdr}->{$key};
}

#sub value_for_key {
#    my $hdr = shift;
#    my $key = shift;
#    return ${%{$header{$hdr}}}{$key};
#}

sub value_for_primary_key {
    my $key = shift;
    return value_for_key("Primary", $key);
}

sub key_for_value {
    my $ref = shift;
    my $hdr   = shift;
    my $value = shift;
    my $key;

    # mcrw 20200518 previous dict reference access syntax deprecated
    my %foo = %{$ref};
    foreach $key (keys $foo{$hdr}) {
#    foreach $key (keys %{%$ref->{$hdr}}) {
	return $key if $value eq value_for_key($ref, $hdr, $key);
    }
    return "";
#    foreach $key (keys %{$header{$hdr}}) {
#	return $key if $value eq value_for_key($hdr, $key);
#    }
#    return "";
}

sub get_comeng {
    my $snr = shift;
    my $rid = shift;

    return ("Comeng915", "Comeng915") if (($rid >= 37200) and ($rid <= 37205));
    if(defined($comeng_rasters{$rid})) {
	my $t = $comeng_rasters{$rid};
	return ("Comeng$t", "Comeng$t");
    }
    return ("Unknown", "Unknown");
}

sub commissioning {
    my $rid = shift;
    my $snr = shift;

    return get_comeng($snr, $rid) if $rid < 49152;
    my $seqc = $snr - 50;
    if(($seqc > 0) and ($deqc < 72)) {
	my $n = sprintf("%02u", $seqc);
	return ("Comcal0$n", "Comcal0$n");
    }
    if(defined($comcal_seqs{$snr})) {
	my $t = $comcal_seqs{$snr};
	return ("Comcal$t", "Comcal$t");
    }
    return ("Unknown", "Unknown");
}

sub dump_hdr {
    my $dict     = shift;

#    print "P ", %$dict->{"Primary"}, " D ,", %$dict->{"DATA"}, "\n";

#    my $fname    = value_for_primary_key("filename");
    my $fname    = value_for_key($dict, "Primary", "filename");
    my $seq_nr   = value_for_key($dict, "Primary", "SEQ_NR");
    my $study_id = value_for_key($dict, "Primary", "STUDY_ID");
    my $rast_id  = value_for_key($dict, "Primary", "RAST_ID");
    my $tl_id    = value_for_key($dict, "Primary", "TL_ID");
    my $stud_acr = value_for_key($dict, "Primary", "STUD_ACR");
    my $rast_acr = value_for_key($dict, "Primary", "RAST_ACR");
    my $target   = value_for_key($dict, "Primary", "TARGET");
    $target      =~ s/ /_/ if $target =~ / /;
    my $date_obs = value_for_key($dict, "Primary", "DATE_OBS");
    my $date_end = value_for_key($dict, "Primary", "DATE_END");
    my $author   = value_for_key($dict, "Primary", "ST_AUTH");
    $author      =~ s/ /_/g;
    $date_obs    =~ s/\.000//;
    $date_end    =~ s/\.000//;
    ($stud_acr, $rast_acr) = commissioning($rast_id, $seq_nr) if $study_id == -1;

    my $rast_req = value_for_key($dict, "Primary", "RAST_REQ");
    my $nexp = value_for_key($dict, "Primary", "NEXP");
#    my $rast_pfd = value_for_key("Primary", "RREP_PFD");
#    my $nraster = value_for_key("Primary", "NRASTER");
    my ($duration, $tsecs)  = duration($date_obs, $date_end);

    my $xcen = value_for_key($dict, "Primary","XCEN");
    my $ycen = value_for_key($dict, "Primary","YCEN");

    my($ccda_tmin, $ccda_tmax, $ccdb_tmin, $ccdb_tmax) = get_ccd_temperatures($dict);

    $bit = value_for_key($dict, "Primary","BITC_VER");
    $img = value_for_key($dict, "Primary","COMPMOD");
    $ac  = value_for_key($dict, "Primary","ACHF_VER");
    $dc  = value_for_key($dict, "Primary","DCHF_VER");
    $qant = value_for_key($dict, "Primary","QTAB_VER");

    $fac = sprintf "0x%04X", (($bit << 11) | ($img << 8) | ($ac << 5) | ($dc << 3) | $qant);
    $name = $comp_fac{"$fac"};

#    format = 
#@>>>>>>>>>>>>>>>>>>>>>>>>>>@>>> @>>>> @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>   @>>>>>>>>>>> @>>>>@>>>>
#$fname, $seq_nr, $rast_id, $stud_acr, $rast_acr, $target, $date_obs, $date_end, $duration, $nexp, $rast_req
#.
#    write;

    format = 
@>>>>>>>>>>>>>>>>>>>>>@>>>>>>@>>>> @>>>>>>>>>>>>>>>>>>> @>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>> @>>>>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>@>>>>@>>>> @######.## @######.## @>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> @########## @#####.## @#####.## @#####.## @#####.## 
$fname, $tl_id, $study_id, $stud_acr, $rast_id, $rast_acr, $target, $name, $date_obs, $date_end, $duration, $nexp, $rast_req, $xcen, $ycen, $author, $tsecs, $ccda_tmin, $ccda_tmax, $ccdb_tmin, $ccdb_tmax
.
    write;
}

#sub header {
#    format = 
#@<<<<<<<<<<<<<<<<<<<<<<<<<<@>>> @>>>> @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>   @>>>>>>>>>>> @>>>>@>>>>
#"Filename", "SEQ", "RAST", "STUDY ACRONYM", "RASTER ACRONYM", "TARGET", "START DATE", "END DATE", "DURATION", "DONE", "REQ"
#.
#    write;
#}

# Input: "2007-06-29T23:44:44.000"
# Input: "2007-06-30T00:44:44.000"

# Input: "2007-06-30T23:44:44.000"
# Input: "2007-07-01T00:44:44.000"
sub duration {
    my $start_str = shift;
    my $end_str = shift;

    my $start_mth  = sprintf("%u", substr($start_str, 5, 2));
    my $start_day  = sprintf("%u", substr($start_str, 8, 2));
    my $start_hr   = sprintf("%u", substr($start_str, 11, 2));
    my $start_min  = sprintf("%u", substr($start_str, 14, 2));
    my $start_sec  = sprintf("%u", substr($start_str, 17, 2));

    my $end_mth  = sprintf("%u", substr($end_str, 5, 2));
    my $end_day  = sprintf("%u", substr($end_str, 8, 2));
    my $end_hr   = sprintf("%u", substr($end_str, 11, 2));
    my $end_min  = sprintf("%u", substr($end_str, 14, 2));
    my $end_sec  = sprintf("%u", substr($end_str, 17, 2));

    $end_hr += 24 if $end_day > $start_day;
    $end_hr += 24 if $end_mth > $start_mth;

    my $time_start = (($start_hr * 3600) + ($start_min * 60) + $start_sec);
    my $time_end   = (($end_hr   * 3600) + ($end_min   * 60) + $end_sec);
    my $diff       = $time_end - $time_start;
    my $seconds = $diff;

    my $output = "";
    my $days = sprintf("%02u", $diff / 86400);
    $diff = $diff - ($days * 86400);
    $output .= ("$days" . "d") if $days != 0;

    my $hours = sprintf("%02u", ($diff / 3600));
    $diff = $diff - ($hours * 3600);
    $output .= ("$hours" . "h") if $hours != 0;

    my $mins = sprintf("%02u", ($diff / 60));
    $diff = $diff - ($mins * 60);
    $output .= ("$mins" . "m");

    my $secs = sprintf("%02u", $diff);
    $output .= ("$secs" . "s");

    return ($output, $seconds);
}

sub get_ccd_temperatures {
    my $dict = shift;
    my $ccda_key = key_for_value($dict, "DATA", "CCDAT_TI");
    my $ccdb_key = key_for_value($dict, "DATA", "CCDBT_TI");

    return(999.99, 999.99, 999.99, 999.99) if $ccda_key eq "";
    return(999.99, 999.99, 999.99, 999.99) if $ccdb_key eq "";

    $ccda_key =~ s/^TTYPE//;
    $ccdb_key =~ s/^TTYPE//;

    my $a_min = value_for_key($dict, "DATA", "TDMIN$ccda_key");
    my $a_max = value_for_key($dict, "DATA", "TDMAX$ccda_key");
    my $b_min = value_for_key($dict, "DATA", "TDMIN$ccdb_key");
    my $b_max = value_for_key($dict, "DATA", "TDMAX$ccdb_key");

    return($a_min, $a_max, $b_min, $b_max);
}
