#!/usr/bin/perl

# fold_reports.pl missing_summary_file exposure_counts_file output_file
use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

die "Wrong number of arguments" if $#ARGV != 5;

$missing = shift;	# $HOME/tmp/missing.txt
$counts  = shift;	# $HOME/tmp/packets_per_exposure.txt
$exposures = shift;	# $translate_log ($HOME/data/staging/logs/md_translation/md_translation_yyyymmdd.txt)
$exp_missing = shift;	# $HOME/tmp/exp_missing.txt
$output  = shift;	# $HOME/tmp/reformat_summary.txt
$cont_check = shift;	# $HOME/tmp/seq_cont.txt

# $HOME/tmp/missing.txt
open(MISS, "< $missing") or die "Can't open missing file: $!";
while(<MISS>) {
    next if /^Filename/;
    chomp;
    ($fname, $rec, $miss, $gaps, $date) = split;
    $missing{$fname} = [$rec, $miss, $gaps];
}
close MISS;

# $HOME/tmp/packets_per_exposure.txt
open(CNT, "< $counts") or die "Can't open counts file: $!";
while(<CNT>) {
    next if /Filename/;
    chomp;
    ($fname, $ppe, $nexps, $tlid, $req, $done, $rid, $mid, $fx, $fy, $expperpos, $vol, $acr) = split;
######    $tot_exps_expect = $nexps * $expperpos;
    $tot_exps_expect = $nexps;
    $md_hdrs_expect  = $tot_exps_expect * $ppe;
    # Add field here for rescue (== "N/A")
    $counts{$fname} = [$ppe, $nexps, $tlid, $req, $done, $rid, $mid, $fx, $fy, $expperpos, $vol, $acr, $tot_exps_expect, $md_hdrs_expect];
}
close CNT;

# $translate_log ($HOME/data/staging/logs/md_translation/md_translation_yyyymmdd.txt)
open(EXP, "< $exposures") or die "Can't open missing file: $!";
while(<EXP>) {
    chomp;
    ($fname, $fffname) = split;
    $trans{$fname} = $fffname;
}
close EXP;

# $HOME/tmp/exp_missing.txt
open(EXP, "< $exp_missing") or die "Can't open exposures missing file: $!";
while(<EXP>) {
    next if /Filename/;
    chomp;
    ($fname, $hdrs) = split;
    $mdHdrs{$fname} = $hdrs;
}
close EXP;

# $HOME/tmp/seq_cont.txt
open(EXP, "< $cont_check") or die "Can't open sequence continuity check file ($cont_check): $!";
while(<EXP>) {
    chomp;
    next if /Filename/;
    ($fname, $start, $end, $diff, $rec) = split;
    $seq_chk{$fname} = [$start, $end, $diff, $rec];
}
close EXP;

# $HOME/tmp/reformat_summary.txt
open(OUTPUT, "> $output") or die "Can't open output file: $!";
print OUTPUT "Filename                    Tl id    Rid   Req  Done                         Acronym     ExpExp ExpGot  Eloss% Ccsds Rec    Missing     Gaps                     Fits File\n";
$previous_fname = "";
foreach $fname (sort keys %missing) {
    $tlid = @{$counts{$fname}}->[2];	# Timeline id
    $rid  = @{$counts{$fname}}->[5];	# Raster id
    $req  = @{$counts{$fname}}->[3];	# Rasters required
    $done = @{$counts{$fname}}->[4];	# Rasters performed
    $acr  = @{$counts{$fname}}->[11];	# Acronym
    $rec  = @{$missing{$fname}}->[0];	# 
    $miss = @{$missing{$fname}}->[1];	# Ccsds missing
    $miss += @{$seq_chk{$previous_fname}}->[2] if $previous_fname ne "";;
    $gaps = @{$missing{$fname}}->[2];	# Ccsds gaps
    ++$gaps if ((@{$seq_chk{$fname}}->[2] != 0) && ($previous_fname ne ""));
    $ff   = $trans{$fname};		# Fits filename
    $tote = @{$counts{$fname}}->[12];	# Total exposures
    $mde  = @{$counts{$fname}}->[13];	# Mission data expected
    $ppe  = @{$counts{$fname}}->[0];	# Packets per exposure
    $mds  = $mdHdrs{$fname};		# 

######    $egot = $mds / $ppe;
    $egot = ($ppe != 0) ? $mds / $ppe : 0;

#print STDERR "mds = $mds, ppe = $ppe, egot = $egot\n";
#    $epc  = ($tote != 0) ? ($egot / $tote) * 100.0 : 0.0;
    $epc  = ($mde != 0) ? 100.0 - (($mds / $mde)) * 100.0 : 100.0;
    $egot_total += $egot;
    $previous_fname = $fname;
    write OUTPUT;
}
close OUTPUT;

format OUTPUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<< @##### @##### @#### @#### @>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>     @##### @##### @###.##   @######    @######  @######   @<<<<<<<<<<<<<<<<<<<<<<<<<<
$fname, $tlid, $rid, $req, $done, $acr, $tote, $egot, $epc, $rec, $miss, $gaps, $ff
.

