#!/bin/sh

# monthly_file_estimation.sh < ~/data/staging/eis_plan/eis_plan_yyyymm*

ccsds_dir=$HOME/data/mission
summary=$HOME/tmp/expected_exposures_summary.txt

if [ -e $summary ]; then
  /bin/rm $summary
fi

for y in 2006 2007 2008
  do
  for m in 01 02 03 04 05 06 07 08 09 10 11 12
    do
    if [ -e $HOME/tmp/exp_count_$y$m.txt ]; then
	/bin/rm $HOME/tmp/exp_count_$y$m.txt
    fi
    for f in `ls $ccsds_dir/$y/$m/packet_check/md_hdrs*`
    do
      ext=${f##*.}
      if [ $ext = txt ]; then
#	  exposure_count_txt.pl < $f | crunch_missing_exposures.pl >> $HOME/tmp/exp_count_$y$m.txt
	  exposure_count_txt.pl < $f  >> $HOME/tmp/exp_count_$y$m.txt
      elif [ $ext = html ]; then
#	  exposure_count.pl < $f | crunch_missing_exposures.pl >> $HOME/tmp/exp_count_$y$m.txt
	  exposure_count.pl < $f  >> $HOME/tmp/exp_count_$y$m.txt
      fi
    done
    
  done

done

#cat $HOME/tmp/exp_count_* | awk -f $HOME/bin/missing_exposures_summary.awk - >> $summary


