#!/usr/bin/env perl

=pod

#title
The EIS line-list database : Version 0.1 02/01/2005

#maxentries
500000

NNCA20A400A20A30n

#itemsN
    ID              I*4      ID (computer generated)N
    WRITE_LOCKED    B*1      (=1) if line list is included in project archiveC
    ACRONYM         C*20     acronym (user supplied)A20
    TITLE           C*400    title (computer generated)A400
    AUTHOR          C*20     authorA20
    DATE            C*30     dateA30
    N_LINES         I*2      (number of populated lines in list)n
    WAVELENGTH(25)  I*2      wavelengths for each linen25
    TYPE(25)        B*1      line type 0=core, 1=project, 2=userC25
    SPLIT(25)       B*1      window is split over central pixelC25

#index
ID          index

=cut

my $database = $ENV{'SSW'} . "/hinode/eis/database/planning_db/technical_db/eis_linelist_db.dbf";
my $buffer;

die "Can't open $study_db: $!" unless sysopen(DB, $database, O_RDONLY);

# Read 0x148 bytes of junk at start
my $num_read = sysread DB, $buffer, 0x248;

while (1) {
    
    $num_read = sysread DB, $buffer, 584;
    last if $num_read == 0;

    my ($en, $id, $wl, $acr, $ti, $au, $da, $nl,@wv) = unpack "NNCA20A400A20A30nn*", $buffer;

    my $last_wl = $nl - 1;
    my @wl = @wv[0 .. $last_wl];

    my $wl = join(',', @wl);

    my $first_type = $nl;
    my $last_type = $first_type + $last_wl;
    my $first_split = $last_type + 1;
    my $last_split = $first_split + $last_wl;

    my $last = $#wv;
#    print "LENGTH wl = ", scalar(@wl), ", LAST = $last\n";
    my @wl1 = @wv[$nl .. $last];
#    print "LENGTH wl1 = ", scalar(@wl1), "\n";
    my $foo = pack "C*", @wl1;
    my @foo = unpack "C*", $foo;
#    print "FOO = @foo (@wl) (@wv)\n";
    my @types = @foo[0 .. ($nl - 1)];
    my @split = @foo[$nl .. (($nl * 2) - 1)];
###    print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$nl|[@wl]|[@types]|[@split]\n";
#    print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$nl|[@wl]\n";
    print "$en|$id|'$acr'|'$ti'|'$au'|'$da'|$nl|[$wl]\n";
}

close DB;
