#!/usr/bin/python

"""
   md_join.py - perform the join operations requested in the file
      generated by Matt's ccsds_md_split_check program.  Run that
      program and direct the output to a file.  The command is
      then

          md_join.py split_check_filename

      The program will perform all the joins listed in the split_check
      file and place them in a join directory under the current
      directory along with all the standalone files.  Thus the join
      directory will contain all the files that can be decompressed.
      This needs to be run in the md/yyyymmdd directory you are
      working on.

      Sorry Matt, but this one is written in python and a bit of a
      kludge as pg4 is running a very old version of python.  Will
      make it better later.

          (7-Dec-2006) JTM
          (19-Dec-2006) JTM: copy standalone files to join directory
"""

import sys
import os
import re
import string

def main():

    print ("Performing requested joins.")

    infile = sys.argv[1]

    f = open(infile, 'r')

    while True:
        line = f.readline()
        if not line:
            break
        elif re.search("discard", line):
            while True:
                if not re.search("eis", f.readline()):
                    break
        elif re.search("standalone", line):
            if not os.path.exists("join"):
                os.makedirs("join")
            fname = f.readline().splitlines()[0]
            command = "cp " + fname.replace("./", "") + " join"
            print (command)
            result = os.system(command)
            print ("Return code = ", result)
            print ()
            while True:
                if not re.search("eis", f.readline()):
                    break
        elif re.search("join", line):
            if not os.path.exists("join"):
                os.makedirs("join")
            fname = f.readline().splitlines()[0]
            command = "cat " + fname.replace("./", "") + " "
            while True:
                n = f.readline().splitlines()[0]
                if re.search("eis", n):
                    command = command + n.replace("./", "") + " "
                else:
                    break
            command = command + " > " + "join/" + fname.replace("./", "")

            # Don't join if only one file listed
            if len(command.split()) > 4:
                print (command)
                result = os.system(command)
                print ("Return code = ", result)
                print ()
    f.close()

if __name__ == "__main__":
    main()
