#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$dest_dir   = "$HOME/tmp";
$dest_file  = "summary";

open(CNT, "< $ARGV[0]") or die "Can't open $ARGV[0]: $!";
open(REC, "< $ARGV[1]") or die "Can't open $ARGV[1]: $!";
open(SUM, "< $ARGV[2]") or die "Can't open $ARGV[2]: $!";

while(<REC>) {
    next if /^#/;
    chomp;
    @line = split;
    $key = shift @line;
    $line = join ' ', @line;
    $rec{$key} = $line;
#    print "[$key] -> [$line]\n";
}

while(<SUM>) {
    next if /^Filename/;
    chomp;
    @line = split;
    $key = shift @line;
    $line = join ' ', @line;
    $sum{$key} = $line;
#    print "[$key] -> [$line]\n";
}

open(RDB, "< $HOME/tmp/raster_db_dump.txt") or die "Can't open raster database: $!";
while(<RDB>) {
    next if /[ ]+Id/;
    chomp;
    @line = split;
    $key = shift @line;
    $line = join ' ', @line;
    $rdb{$key} = $line;
#    print "[$key] -> [$line]\n";
}

dbmopen(%md0, "$HOME/work/localdata/database/translation/md2l0_2006.db", '0444') or die "Can't open md2l0_2006.db: $!";
dbmopen(%md1, "$HOME/work/localdata/database/translation/md2l0_2007.db", '0444') or die "Can't open md2l0_2007.db: $!";
dbmopen(%md2, "$HOME/work/localdata/database/translation/md2l0_2008.db", '0444') or die "Can't open md2l0_2008.db: $!";

print "# Filename                  Ppe  Num exps  Tl_id Reps_req Reps_done   Rid   Mid full_x full_y   ExpPerPos  Data_vol  MD_hdrs_rec  Ccsds_rec  Ccsds_miss    Gaps              Raster Acronym  Nexps                     Fits file\n";

while(<CNT>) {
    next if /^#/;
    chomp;
    @line = split;
#    $key = shift @line;
     ($fname, $packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume) = split;
    $hdrs_rec = 0;
    $ccsds_rec = $ccsds_miss = $gaps = 0;
    $hdrs_rec = $rec{$fname} if defined($rec{$fname});

    if(defined($sum{$fname})) {
	@thing = split / /, $sum{$fname};
	$ccsds_rec = $thing[0];
	$ccsds_miss = $thing[1];
	$gaps = $thing[2];
    }

    ($raster_acr, $exp_in_raster) = raster_acr($rid);

    $fits_name = get_fits_name($fname);

#    print "[$fname] -> [$packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume]\n";
    write;
}


close CNT;
close REC;
close SUM;
close RDB;

dbmclose %md0;
dbmclose %md1;
dbmclose %md2;

format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<< @### @########  @####    @####     @#### @>>>> @>>>>  @####  @####          @# @########       @#####    @######     @###### @###### @>>>>>>>>>>>>>>>>>>>>>>>>>>  @#### @>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$fname, $packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume,   $hdrs_rec, $ccsds_rec, $ccsds_miss, $gaps, $raster_acr, $exp_in_raster, $fits_name
.


sub raster_acr {
    my $rid = shift;
    my $acr;
    my $nexps;
    my @line;
    if(defined($rdb{$rid})) {
	@line = split ' ', $rdb{$rid};
	return ($line[0], $line[2]);
    }
    return ("Unknown", -1);
}
       
sub get_fits_name {
    my $md_name = shift;
    return $md0{$md_name} if defined($md0{$md_name});
    return $md1{$md_name} if defined($md1{$md_name});
    return $md2{$md_name} if defined($md2{$md_name});
    return "No fits";
}
