#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/date_calc.pl"     or $date_calc_fail = 1;
do "$EGSE_SW_LIB/pipeline_defs.pl" or $pipeline_defs_fail = 1;
do "$EGSE_SW_LIB/pipeline.pl"      or $pipeline_fail = 1;


my $log_dir = "$HOME/work/localdata/log/merge";
my $tmp_dir = $log_dir . "/tmp";
my $year = "2012";
my $month = "01";
my $day = "25";
my $date_str = "20120125" . "*";

for($i = 0; $i < 16; ++$i) {
    $offset[$i] = 5400 * $i;
}

my %intervals = ('STS1' => '2',
		 'STS2' => '10',
		 'STS3' => '10',
		 'HK1'  => '2',
		 'HK2'  => '2',
		 'HK3'  => '1',
		 'SOT'  => '2',
		 'MDP'  => '2');

my %fits_files = (STS1 => 'eis_sts1',
		  STS2 => 'eis_sts2',
		  STS3 => 'eis_sts3',
		  HK1  => 'eis_hk1',
		  HK2  => 'eis_hk2',
		  HK3  => 'eis_aocs1',
		  SOT  => 'eis_sot',
		  "MDP"  => 'eis_mdp');
		   
# Get a list of the files in date order
my @files = `ls $log_dir/$date_str`;

my $missing_packets_idl_file = $log_dir . "/missing_data.pro";

$foo = open(IDL, "> $missing_packets_idl_file");
goto bad_section unless $foo == 1;
foreach $type qw(STS1 STS2 STS3 HK1 HK2 HK3 SOT MDP) {
    $count = 0;
    foreach $file (@files) {
	chomp $file;
	my $new_file = $tmp_dir . "/" . substr($file, -17, 14) . "$type";
	my $time = substr($file, -9, 5);
##	print "grep $type $file | awk '{print \$11}' > $new_file\n";
##	system("grep $type $file | awk '{print \$11}' > $new_file");
	`grep $type $file | awk '{print \$11}' > $new_file`;
	my $yyyymmddhhmm = $year . $month . $day . $time;
	print IDL "missing_packets, type=$type, '$new_file', $offset[$count], $intervals{$type}, '$temp_fits/$fits_files{$type}_$yyyymmddhhmm.fits', $HOME/tmp/status_reformat/\n";
	++$count;
    }
}
close IDL;
bad_section:

    `/bin/rm $tmp_dir/* $log_dir/*
