#!/usr/bin/perl

#
# Copy today'sn op_period file on eisco to the op_period directory
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(LOG, ">> $pipeline_log/op_period_cron.txt");
#($log, $perform, $title) = init_log_and_perform(*LOG, "interactive");

#
# Create the pass list files for the next week
#
@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

#
# If today is sunday then don't do anything
#
exit if($today[6] == 0);

#
# Split today's date up
#
$year  = sprintf "%04u", $today[5];	# Get starting year
$month = sprintf "%02u", $today[4];	# Get starting month
$day   = sprintf "%02u", $today[3];	# Get starting day
$current_time = scalar(localtime);
#print LOG "$current_time: today's date is $year $month $day\n";
print LOG "$current_time\n";

#
# Make the source filename
#
$src_file  = "op_period_" . "$year$month$day" . "????.evt";
#$cmdpln    = "$HOME/eisco/cmdpln";
$cp_cmdpln = "$HOME/eisco/../cp/cmdpln/" . "$year$month$day";
$op_period_dir = "$HOME/data/staging/op_period/";

print LOG "\tLooking for $src_file in $cp_cmdpln/". "$year$month$day" . "\n";
#
# If there is a matching file in eisco's latest directory then copy it across
#

if( -e "$cp_cmdpln/$src_file") {
    print LOG "\tFOUND $src_file in $cp_cmdpln\n";
    system("/bin/cp $cmdpln/$src_file $op_period_dir");
}
else {
    print LOG "\t$src_file not found\n";
}

close(LOG);

system("/bin/cp $pipeline_log/op_period_cron.txt $HOME/data/staging/op_period/");
