
SDTP="${HOME}/bin/sdtp"

state="cron"

ant='usc34'	# Not needed for merge as sdtp will substitute merge antenna
band=3		# Merge telemetry
mode='merge'	# Merge telemetry

TEMP_IDL="${HOME}/work/localdata/tmp_idl"

PIPELINE_LOG="${HOME}/work/localdata/log/pipeline_log.txt"
RESCUE="$temp_idl/rescue.pro"

function announce {
    date_today=`date`
    echo -n ${date_today} $1 started $2 >> ${PIPELINE_LOG}

}

function pipeline_exit {
    echo '\t' $1 exited at `date` >> ${PIPELINE_LOG}
}

function init_pipeline {
    state=$1
    DARTS_MISSION="${HOME}/data/mission"
    MERGE_DIR=""
}

function init_local_logs {
    LOCAL_LOG="${HOME}/work/localdata/log/pipeline_mission_log_${1}"
    SDTP_FETCH_LOG=""
    MD_HDR_CHECK_LOG=""
    CCSDS_PACKET_CHECK_LOG=""
    MISSING_PACKETS_FILE="${MERGE_DIR}/missing_packets.txt"
    MISSING_PACKETS_FILE_DARTS="${DARTS_MISSION}/${2}/${3}/packet_check/missing_packets_${1}.txt"
    HEADLESS_PACKET_FILE=""
    HEADLESS_PACKET_FILE_DARTS=""
    TAILLESS_PACKET_FILE=""
    TAILLESS_PACKET_FILE_DARTS=""
}

function stage_title {
    if [ ${state} = "interactive" ]; then
	echo ${1}
    fi
    echo ${1} >> ${LOCAL_LOG}
}

function log_msg {
    if [ ${state} = "interactive" ]; then
	echo '\t' ${1}
    fi
    echo '\t' ${1} >> ${LOCAL_LOG}
}

function perform {
    log_msg(${1})
    foo=`eval ${1}`
    echo ${foo}
    log_msg(${foo})
}
