#!/usr/local/bin/perl

#
##maxentries
#500000
# 
##items
#ID               I*4      ID (computer generated)
#WRITE_LOCKED     B*1      (=1) If raster is archived in mission DB
#ACRONYM          C*20     acronym (user supplied)
#TITLE            C*160    title (computer generated)
#AUTHOR           C*20     Line List author
#DATE             C*30     Date when Line List was created
#RASTERTYPE       B*1      0/1 = Scanning/Sit'n'stare
#SCAN_FM_NSTEPS   I*4      Scanning Raster - number of fine mirror steps
#SCAN_FM_STEPSIZE R*4      Scanning Raster - fine mirror step size
#SNS_NEXPS        I*4      Sit'N'Stare Raster - number of exposures
#SNS_DURATION     I*4      Sit'N'Stare Raster - duration (seconds)
#LL_ID            I*4      associated line-list ID
#N_WINDOWS        I*2      (number of populated data windows)
#DATA_WINDOWS(25) I*2      window widths for each populated line
#WIND_HEIGHT      I*2      window height
#WIND_WIDTH       I*2      window (default) width
#SLIT_INDEX       I*2      slit/slot width, range 0-3, see EIS_CPT
#NEXP             I*2      number of populated exposures
#EXPOSURES(8)     I*4      exposure times (milli seconds)
#DELAYS(8)        I*4      delay times    (milli seconds)
#COMPRESSION      I*2      Compression scheme
#SPLIT            I*2      One/more windows span the central pixel
#RA_DURATION      I*8      raster duration (seconds)
#RA_DATA_VOLUME   I*8      raster data volume (k bytes)
# 
##index
#ID          index
#

die unless $#ARGV == 0;
$db = shift;
open(DB, "< $db") or die "Can't open $db: $!\n";
$count = read(DB, $junk, (25 * 16) + 8);
while(!eof(DB)) {
    extract_parameters();
    print_parameters();
}
close DB;

sub extract_parameters {
    $count = read(DB, $id,                4);
    $count = read(DB, $write_locked,      1);
    $count = read(DB, $acronym,          20);
    $count = read(DB, $title,           160);
    $count = read(DB, $author,           20);
    $count = read(DB, $date,             30);
    $count = read(DB, $rastertype,        1);
    $count = read(DB, $scan_fm_nsteps,    4);
    $count = read(DB, $scan_fm_stepsize,  4);
    $count = read(DB, $sns_nexps,         4);
    $count = read(DB, $sns_duration,      4);
    $count = read(DB, $ll_id,             4);
    $count = read(DB, $n_windows,         2);
    $count = read(DB, $data_windows,      2 * 25);
    $count = read(DB, $wind_height,       2);
    $count = read(DB, $wind_width,        2);
    $count = read(DB, $slit_index,        2);
    $count = read(DB, $nexp,              2);
    $count = read(DB, $exposures,         4 * 8);
    $count = read(DB, $delays,            4 * 8);
    $count = read(DB, $compression,       2);
    $count = read(DB, $split,             2);
    $count = read(DB, $ra_duration,       8);
    $count = read(DB, $ra_data_volume,    8);

#    $count = read(DB, $junk, (3 * 16) + 12);
    $count = read(DB, $junk, 4);

    @id               = unpack "C*", $id;
    @write_locked     = unpack "C*", $write_locked;
#    @date             = unpack "C*", $n_repeats;
    @rastertype       = unpack "C*", $rastertype;
    @scan_fm_nsteps   = unpack "C*", $scan_fm_nsteps;
    @scan_fm_stepsize = unpack "C*", $scan_fm_stepsize;
    @sns_nexps        = unpack "C*", $sns_nexps;
    @sns_duration     = unpack "C*", $sns_duration;
    @ll_id            = unpack "C*", $ll_id;
    @n_windows        = unpack "C*", $n_windows;
    @data_windows     = unpack "C*", $data_windows;
    @wind_height      = unpack "C*", $wind_height;
    @wind_width       = unpack "C*", $wind_width;
    @slit_index       = unpack "C*", $slit_index;
    @nexp             = unpack "C*", $nexp;
    @exposures        = unpack "C*", $exposures;
    @delays           = unpack "C*", $delays;
    @compression      = unpack "C*", $compression;
    @split            = unpack "C*", $split;
    @ra_duration      = unpack "C*", $ra_duration;
    @ra_data_volume   = unpack "C*", $ra_data_volume;

}

sub print_parameters {
    dump_list_parameter1("Id             : '", \@id);
    dump_list_parameter("Write locked   : '", \@write_locked);
    print "Acronym        : [$acronym]\n";
    print "Ttitle         : [$title]\n";
    print "Author         : [$author]\n";
    print "Date           : [$date]\n";
    dump_list_parameter("Raster type    : '", \@rastertype);
    dump_list_parameter("Fm nsteps      : '", \@scan_fm_nsteps);
    dump_list_parameter("Fm stepsize    : '", \@scan_fm_stepsize);
    dump_list_parameter("Sns nexps      : '", \@sns_nexps);
    dump_list_parameter("Sns duration   : '", \@sns_duration);
    dump_list_parameter("Ll id          : '", \@ll_id);
    dump_list_parameter("N windows      : '", \@n_windows);
#    dump_list_parameter("Data windows : '", \@);
    dump_list_parameter("Wind height    : '", \@wind_height);
    dump_list_parameter("Wind width     : '", \@wind_width);
    dump_list_parameter("Slit index     : '", \@slit_index);
    dump_list_parameter("Nexp           : '", \@nexp);
    dump_list_parameter("Exposures      : '", \@exposures);
    dump_list_parameter("Delays         : '", \@delays);
    dump_list_parameter("Compression    : '", \@compression);
    dump_list_parameter("Split          : '", \@split);
    dump_list_parameter("Ra duration    : '", \@ra_duration);
    dump_list_parameter("Ra data volume : '", \@ra_data_volume);
    print "\n";
}

sub dump_parameter {
    my $title = shift;
    
}

sub dump_list_parameter {
    my $title = shift;
    my $list = shift;
    my $str = "";

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    print "$str'\n";
}

sub dump_list_parameter1 {
    my $title = shift;
    my $list = shift;
    my $str = "";
    my $num;

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    $num = sprintf "%u", hex($str);
    print "$str ($num)'\n";
}
