#!/usr/bin/env perl

=pod


#title
The EIS raster database : Version 0.0 22/11/2004
                        : Version 0.1 June 2005 - raster-timeline properties added.

#maxentries
500000

#items
ID               I*4      ID (computer generated)
WRITE_LOCKED     B*1      (=1) If raster is archived in mission DB
ACRONYM          C*20     acronym (user supplied)
TITLE            C*160    title (computer generated)
AUTHOR           C*20     Line List author
DATE             C*30     Date when Line List was created
RASTERTYPE       B*1      0/1 = Scanning/Sit'n'stare
SCAN_FM_NSTEPS   I*4      Scanning Raster - number of fine mirror steps
SCAN_FM_STEPSIZE R*4      Scanning Raster - fine mirror step size
SNS_NEXPS        I*4      Sit'N'Stare Raster - number of exposures
SNS_DURATION     I*4      Sit'N'Stare Raster - duration (seconds)
LL_ID            I*4      associated line-list ID
N_WINDOWS        I*2      (number of populated data windows)
DATA_WINDOWS(25) I*2      window widths for each populated line
WIND_HEIGHT      I*2      window height
WIND_WIDTH       I*2      window (default) width
SLIT_INDEX       I*2      slit/slot width, range 0-3, see EIS_CPT
NEXP             I*2      number of populated exposures
EXPOSURES(8)     I*4      exposure times (milli seconds)
DELAYS(8)        I*4      delay times    (milli seconds)
COMPRESSION      I*2      Compression scheme
SPLIT            I*2      One/more windows span the central pixel
RA_DURATION      I*8      raster duration (seconds)
RA_DATA_VOLUME   I*8      raster data volume (k bytes)

#index
ID          index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $raster_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/technical_db/eis_raster_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $raster_db: $!" unless sysopen(DB, $raster_db, O_RDONLY);

my $format;

if ($comma_delimit_lists) {
    $format = "NNCA20A160A20A30CNNNNNnn25nnnnN8N8nnNNNN";
}

# Read 0x194 bytes of junk at start
my $num_read = sysread DB, $buffer, 0x194;

while (1) {
    
    $num_read = sysread DB, $buffer, 404;
    last if $num_read == 0;

    if ($comma_delimit_lists) {
	my ($en,$id,$wl,$acr,$ti,$au,$da,$rt,$scns,$scss,$snns,$sndu,$ll,$nw,$w,$w1,$w2,$w3,$w4,$w5,$w6,$w7,$w8,$w9,$w10,$w11,$w12,$w13,$w14,$w15,$w16,$w17,$w18,$w19,$w20,$w21,$w22,$w23,$w24,$ht,$wi,$sla,$nexp,$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$d,$d1,$d2,$d3,$d4,$d5,$d6,$d7,$co,$sp,$radums,$raduls,$ravolms,$ravolls) = unpack $format, $buffer;
	my $radu = sprintf "%lu", $radums + $raduls;
	my $ravol = sprintf "%lu", $ravolms + $ravolls;
	print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$rt|$scns|$scss|$snns|$sndu|$ll|$nw|[$w,$w1,$w2,$w3,$w4,$w5,$w6,$w7,$w8,$w9,$w10,$w11,$w12,$w13,$w14,$w15,$w16,$w17,$w18,$w19,$w20,$w21,$w22,$w23,$w24]|$ht|$wi|$sla|$nexp|[$e,$e1,$e2,$e3,$e4,$e5,$e6,$e7]|[$d,$d1,$d2,$d3,$d4,$d5,$d6,$d7]|$co|$sp|$radu|$ravol\n";
    }
    else {
	my ($en, $id, $wl, $acr, $ti, $au, $da, $rt, $scns, $scss, $snns, $sndu, $ll, $nw, @win) = unpack "NNCA20A160A20A30CNNNNNnn25", $buffer;
	my ($ht, $wi, $sla, $nexp, @exp) = unpack "x312nnnnN8", $buffer;
	my (@del) = unpack "x352N8", $buffer;
	my ($co, $sp, $radums, $raduls, $ravolms, $ravolls) = unpack "x384nnNNNN", $buffer;
	my $radu = sprintf "%lu", $radums + $raduls;
	my $ravol = sprintf "%lu", $ravolms + $ravolls;
###	print "$en|$id|$wl|'$acr'|'$ti'|'$au'|'$da'|$rt|$scns|$scss|$snns|$sndu|$ll|$nw|[@win]|$ht|$wi|$sla|$nexp|[@exp]|[@del]|$co|$sp|$radu|$ravol\n";
	print "Entry         : $en\n";
	print "Id            : $id\n";
	print "Write locked  : $wl\n";
	print "Acronym       : '$acr'\n";
	print "Title         : '$ti'\n";
	print "Author        : '$au'\n";
	print "Date          : '$da'\n";
	print "Type          : $rt\n";
	print "Scan n steps  : $scns\n";
	print "Scan stepsize : $scss\n";
	print "Sns nexps     : $snns\n";
	print "Sns duration  : $sndu\n";
	print "Ll id         : $ll\n";
	print "N windows     : $nw\n";
	print "Data windows  : [@win]\n";
	print "Window height : $ht\n";
	print "Window width  : $wi\n";
	print "Sla index     : $sla\n";
	print "N exp         : $nexp\n";
	print "Exp times     : [@exp]\n";
	print "Delay times   : [@del]\n";
	print "Compression   : $co\n";
	print "Split         : $sp\n";
	print "Duration      : $radu\n";
	print "Data volume   : $ravol\n\n";
    }
}

close DB;

sub commafy_list {
    my $list_ref = shift;
    my @list;
    foreach my $element (@$list_ref) {
	push @list, "$element,";
    }
    chop $list[-1];
#    print "@list\n";
    @$list_ref = @list;
#    my @list = `sed 's/ /,/g' @$list_ref`;
###    print "COMMAFY (@list)\n";
#    print "COMMAFY (\@list)\n";
}
