BEGIN {
#  printf "%3s %30s %4s %4s %6s %4s %4s %6s %6s %6s %5s\n", "Id", "Acronym", "Fx", "Fy", "Vol", "PpE", "#Ex", "AvgE", "Elos%", "Clos%", "Num"
}

{
  acr     = $17;
  fx      = $9;
  fy      = $10;
  num_exp = $3;
  vol     = $12;
  ppe     = $2;
  id      = $7;
  num_hdr = $13;
}
{
  exp_exps += num_exp;
  if(num_hdr > (ppe * num_exp)) {
    rec_exps += 0;
  }
  else {
    if(ppe == 0) {
      rec_exps += 0;
    }
    else {
      rec_exps += (num_hdr / ppe);
    }
  }
  ccsds_tot += $14;
  ccsds_miss += $15;
}

END {
###  print exp_exps/NR, rec_exps/NR, ((rec_exps/NR)/(exp_exps/NR)*100.0);

##  printf "%3u %s, %ux%u (%u pix/exp, %u md hdrs/exp), %u exps/raster, average %.2f exps, %.2f%% exposure loss rate, %.2f%% ccsds loss rate (%u files)\n", id, acr, fx, fy, vol, ppe, num_exp, (rec_exps/ppe)/NR, 100.0 - ((rec_exps/NR)/(exp_exps/NR)*100.0), (ccsds_miss/ccsds_tot) * 100.0, NR;

#  printf "%3u %s, %ux%u (%u pix/exp, %u md hdrs/exp), %u exps/raster, average %.2f exps, %.2f%% exposure loss rate, %.2f%% ccsds loss rate (%u files)\n",
#    id,
#    acr,
#    fx,
#    fy,
#    vol,
#    ppe,
#    num_exp,
#    rec_exps/NR,
#    100.0 - ((rec_exps/NR)/(exp_exps/NR)*100.0),
#    (ccsds_miss/ccsds_tot) * 100.0,
#    NR;

  if(exp_exps == 0) {
    exp_loss_rate = 0.0;
  }
  else {
    exp_loss_rate = 100.0 - (rec_exps/exp_exps)*100.0;
  }
  if(ccsds_tot == 0) {
    ccsds_loss_rate = 0.0;
  }
  else {
    ccsds_loss_rate = (ccsds_miss / ccsds_tot) * 100.0;
  }
  printf "%8s %5u %30s %4u %4u  %7u %3u %4u %7.2f %6.2f %6.2f %5u\n",
    yyyymm,
    id,
    acr,
    fx,
    fy,
    vol,
    ppe,
    exp_exps,
#    rec_exps/NR,
    rec_exps,
##    100.0 - ((rec_exps/NR)/(exp_exps/NR)*100.0),
#    100.0 - (rec_exps/exp_exps)*100.0,
    exp_loss_rate,
#    (ccsds_miss/ccsds_tot) * 100.0,
    ccsds_loss_rate,
    NR;
}
