#!/bin/sh

# new_rescue.sh log_filename

# Set up defaults
merge_rescue=0
log_file_suffix="new_rescue_${1}"

# Check args
if [ $# -gt 1 ]; then
    if [ $1 == "-m" ]; then
	merge_rescue=1
    fi
    log_file_suffix="new_rescue_${2}"
fi

rescue_dir=${HOME}/work/localdata/sdtp/merge/rescue
merge_dir=${HOME}/work/localdata/sdtp/merge

decomp_dir=${HOME}/work/localdata/sdtp/merge/decompressed

log_file=${HOME}/work/localdata/log/rescue/${log_file_suffix}
hdr_file=${HOME}/work/localdata/log/rescue/rescue_format.txt
fits_dir=${HOME}/work/localdata/pipeline/fits

soda_dir=/soda/hinode/eis/level0
log_dir=${HOME}/data/staging/logs/pipeline_mission/rescue

if [ -e ${log_file} ]; then
    /bin/rm ${log_file}
    touch ${log_file}
fi

# 1
/bin/rm ${merge_dir}/eis_*
/bin/rm ${decomp_dir}/eis_*

# Don't remove the fits files if rescue.sh called during merge reformat
if [ ${merge_rescue} -eq 0 ]; then
    /bin/rm ${fits_dir}/eis_*
fi

cat ${hdr_file} > ${log_file}
for f in `ls ${rescue_dir}` ; do
#    rescue_file.pl ${rescue_dir}/${f} >> ${log_file}
    ${HOME}/bin/new_rescue ${rescue_dir}/${f} ${merge_dir}/${f}
done

#exit

rescue_decomp_chk_tbl.pl $@
rescue_reformat_chk_tbl.pl $@

# Now move fits files to /soda
#for f in `ls ${fits_dir}` ; do
#    y=${f:7:4}
#    m=${f:11:2}
#    d=${f:13:2}
#    echo "mv ${fits_dir}/${f} ${soda_dir}/${y}/${m}/${d}"
#    mv ${fits_dir}/${f} ${soda_dir}/${y}/${m}/${d}
#done

# Now remove ccsds files from rescue, merge, decompressed
blf=`basename ${log_file}`
/bin/mv ${log_file} ${log_dir}/${blf}
