BEGIN {
    print "Filename            Flags  Packets  Processed  Integers out  Integers in  Compression ratio  Code  dctbl,dpcm12,dct12  Fix applied  Error";
}

END {

}

function print_file(line) {
#    start_index = index(line, "eis_md")
    start_index = match(line, "eis_md")
    printf(substr(line, start_index, length(line) - start_index + 1) " ")
}

function print_fix(line) {
    where = index(line, "No")
    printf 1 - where " "
}

function print_error(line) {
    gsub(/^ /,"",line)
    print " '"line"'"
}

/File/          { print_file($2)   }
/flags/         { printf(" %4s ", $4) }
/Packets/       { printf("%5u ", $2) }
/Processed/     { printf("%u ", $2)  }
/Integers in/   { printf("%9u ", $4) }
/Integers out/  { printf("%9u ", $3) }
/Compression/   { printf("%5.2f ", $2)  }
/comp_code/     { printf("%s ", $3)   }
/dctbl/         { printf("%u %u %u ", $5, $6, $7) }
/fix/           { print_fix($0)   }
/Error/         { print_error($2) }
