BEGIN {
    print "Filename\tPackets\tProcessed\tIntegers in\tIntegers out\tCompression ratio\tCode\tdctbl,dpcm12,dct12\tFix applied\tE\
rror"
}

END {

}

function print_file(line) {
    start_index = match(line, "eis_md")
    printf(substr(line, start_index, length(line) - start_index + 1) " ")
}

function print_fix(line) {
    where = index(line, "No")
    printf 1 - where " "
}

function print_error(line) {
    gsub(/^ /,"",line)
    print "'"line"'"
}

/File/          { print_file($2) }
/Packets/       { printf $2 " "  }
/Processed/     { printf $2 " "  }
/Integers in/   { printf $4 " "  }
/Integers out/  { printf $3 " "  }
/Compression/   { printf $2 " "  }
/comp_code/     { printf $3 " "  }
/dctbl/         { printf $5 " " $6 " " $7 " " }
/fix/           { print_fix($0)  }
/Error/         { print_error($2) }
