#!/usr/local/bin/perl

# Split ccsds packet archive into seperate archives of single packet type.

use Env qw(EGSE_SW_LIB);

use lib "$EGSE_SW_LIB/perllib/CcsdsLib/";

use CcsdsInterface;
use File::Basename;

if($#ARGV == 0) { $filename = $ARGV[0]; }
#else { print STDOUT "Supply filename to process\n"; write_log($filename, "No file supplied"); exit; }
else {
    print STDOUT "Supply filename to process\n";
#    write_log($filename, "No file supplied");
    exit;
}

@files = @ARGV;

%suffix = (0x5C4 => '_sts1',
           0x5C6 => '_sts2',
           0x5C8 => '_sts3',
           0x420 => '_hk1',
           0x428 => '_hk2',
           0x440 => '_hk3',
	   0x542 => '_sot',
	   0x5C2 => '_mdp');

$bname = basename($filename);
$dname = dirname($filename);

foreach $k (keys %suffix) {

    $outfile = $filename . $suffix{$k};

    $archive = CcsdsInterface->new();
    if($archive->openForReading($filename)) {
        $archive->setPrimaryHeaderLength(6);
        $archive->setSecondaryHeaderLength(4);
        die unless $archive->openForWriting($outfile);
        $archive->setEndian("big");         # Not necessary, big is default                                                                                     

        while($archive->nextPacketWithApid($k)) {
            $archive->write($archive->packet());
        }
        $archive->closeInput();
        $archive->closeOutput();

    }
}
