#!/usr/local/bin/perl
# !/usr/bin/env perl

# Split ccsds packet archive into seperate archives of single packet type. Expects the whole day's data.
# Supply the 16 ccsds packet archives in turn in the form directory_containing_ccsds_files/*

use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib/";

do "$EGSE_SW_LIB/pipeline_defs.pl" or die "Failed pipeline_defs.pl";
do "$EGSE_SW_LIB/pipeline.pl"      or die "Failed pipeline.pl";;  

use CcsdsInterface;
use File::Basename;

$search_apid = 0x440;

%suffix = (
    0x5C4 => '_sts1',
    0x5C6 => '_sts2',
    0x5C8 => '_sts3',
    0x420 => '_hk1',
    0x428 => '_hk2',
    0x440 => '_hk3',
    0x542 => '_sot',
    0x5C2 => '_mdp',
    );

foreach $file (@ARGV) {
    $debug = 1 if $file =~/-d/;
    next unless $file =~ /eis_sts_/;    # Don't process if no ccsds files
    chomp $file;
    $bname = basename($file);           # Get basename (eis_sts_yyyymmdd_hhmmss...)
    $dname = dirname($file);            # Get path to file but not including file
    print "$file\t$bname\t$dname\n" if $debug;

    foreach $k (sort keys %suffix) {
        print "Doing $suffix{$k} for $file...\n" if $debug;
####        $outfile = "$SPLIT_STS_DIR" . "/" . $bname . $suffix{$k};
        $outfile = "$HOME" . "/tmp/split_sts_ccsds/" . $bname . $suffix{$k};
	print "outfile is $outfile\n" if $debug;
        $archive = CcsdsInterface->new();
        print "Opening $file\n" if $debug;
        if($archive->openForReading($file)) {
            print "READING FILE\n" if $debug;
            $archive->setPrimaryHeaderLength(6);
            $archive->setSecondaryHeaderLength(4);
#           system("/bin/touch $outfile");
#           die "Can't open outfile $outfile\n" unless $archive->openForWriting($outfile);
            die "Can't open $outfile because $!" unless $archive->openForWriting($outfile);
            $archive->setEndian("big");         # Not necessary, big is default 
            $num_packets = 0;
            while($archive->nextPacketWithApid($k)) {
                $archive->write($archive->packet());
                ++$num_packets;
            }
            $archive->closeInput();
            $archive->closeOutput();
            $hkey = sprintf "%X", $k;
            print STDOUT "Key: 0x$hkey (", $suffix{$k}, ")\tNumber of packets: $num_packets\n" if $debug;
        }
        else {
#            print "Can't open $file for reading\n";
            die "Can't open $file for reading because $1";
        }
    }
}
