#!/usr/local/bin/perl -W

use Time::Local;
use Date::Calc;

use Hinode::EIS::Reformatter::date_calc;
use Hinode::EIS::EisPipeline::pipeline_defs;
use Hinode::EIS::EisPipeline::pipeline;

###use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

###do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
###do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
###do "$EGSE_SW_LIB/pipeline.pl"      || die "Can't do pipeline.pl: $!\n";

#my $sdate = "20220924";
my $bool  = 0;
my $msg   = "";

my $num_args = $#ARGV + 1;
if ($num_args != 1) {
    print "Need a date in the form yyyymmdd\n";
    die 1;
}

my $sdate = $ARGV[0];

my @expected_exposures_list = exposures_list_from_orl($sdate, \$bool, \$msg);
print "$sdate: $bool, $msg, @expected_exposures_list\n";

sub exposures_list_from_orl {
    my $date = shift;
    my $bool_ref = shift;
    my $msg_ref = shift;

    my $yyyy = substr($date, 0, 4);
    my $src_file = "EIS_" . "$date" . "????.orl";
    my $file = `/bin/ls $pipeline_defs::darts_orl_dir/$yyyy/$src_file`;
    print "DATE = $date\n";
    print "Looking in $pipeline_defs::darts_orl_dir/$yyyy for file $src_file\n";
    if($file eq "") {
	$$msg_ref = "Can't find orl file for $date\n";
	return ();
    }
    chomp $file;
    if(!open(ORL, "< $file")) {
	$$msg_ref = "Can't open orl file $file\n";
	return ();
    }
#    print "Reading from $file\n";
    my $line = "";
    while(<ORL>) {
	next if /^[ \t]*$/;
	next if /^[ \t]*START:OPOG_UPLOAD_TI/;
	if(/^[ \t]*START/) {
	    # Read 3 more lines to skip past dump obstbl line
#	    <ORL>;
#	    <ORL>;
#	    <ORL>;
#	    print "Last skip: $_";
	    last;
	}
    }
#    print "FOO: $_";
    while(<ORL>) {
#	print "LINE = $_";
	last if /^[ \t]*\/\*\-/;
	next unless /^[ \t]*START/;
#	print "LINE1 = $_";
	chomp;
	decode($_);
    }
    close ORL;
#    print "Last line read: $_";
    $$bool_ref = 1;
    $$msg_ref = "Ok";
}

sub decode {
    my $line = shift;
    print "$line\n";
    my $num  = substr $line, -9, 3;
#    print "$num\n";
    return;

}
