#!/usr/local/bin/perl                                                                                                                                                 

use Time::Local;
use Date::Calc;
use File::Basename;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use CcsdsInterface;
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
do "$EGSE_SW_LIB/status_apids.pl" || die "Can't do status_apids.pl: $!\n";

my %filenames;
my %headless;
my %incomplete;
my %files_seq_counts;

if(@ARGV == ()) {
    die "No arguments";
}

$archive = CcsdsInterface->new();
foreach $file (@ARGV) {
    my %file_summary;
    my @starts = (1,1,1,1,1,1,1,1);

    foreach my $k (sort keys %status_apids) {
	foreach my $i (0 .. 2) {
	    $file_summary{$k}[$i] = 0;
	}
    }

    chomp $file;

#    $outputFilename = $file . ".out.txt";
#    die "Can't open output file: $!" unless open(OUT, "> $outputFilename");

    if($archive->openForReading("$file")) {

        $archive->setPrimaryHeaderLength(6);
        $archive->setSecondaryHeaderLength(4);
        $archive->setEndian("big");

        $sts1_start = $sts2_start = $sts3_start = $sts1_end = $sts2_end = $sts3_end = 1;
        $sts1_count = $sts2_count = $sts3_count = 0;

	$hk1_start = $hk2_start = $aocs_start = $sot_start = $eismdp_start = 1;
	$hk1_end = $hk2_end = $aocs_end = $sot_end = $eismdp_end = 1;
	$hk1_start_count = $hk2_start_count = $aocs_start_count = $sot_start_count = $eismdp_start_count = 0;
	$hk1_end_count = $hk2_end_count = $aocs_end_count = $sot_end_count = $eismdp_end_count = 0;
	$hk1_count = $hk2_count = $aocs_count = $sot_count = $eismdp_count = 0;

        $seen_packet = 0;

        while(1) {

            if($archive->nextPacket()) {

                ++$seen_packet;

		my $apid = $archive->packetApid();
		my $seq_count = $archive->sequence_count();
		if (exists($status_apids{$apid})) {
		    print "Found apid $apid (", $starts[$status_apids{$apid}], ", $seq_count)\n";
		    print "Woooo\n" if($starts[$status_apids{$apid}]);
#		    $file_summary{$apid}[0] = 1;
#		    $file_summary{$apid}[1] = 2;

		    $file_summary{$apid}[0] = $seq_count if ($starts[$status_apids{$apid}]);
		    $starts[$status_apids{$apid}] = 0;
		    $file_summary{$apid}[2] = $seq_count;
		    ++($file_summary{$apid}[1]);
		    message("FOO");
#		    foreach my $k (sort %file_summary) {
#			print "$k -> ", $file_summary{$k}->[0], "\t", $file_summary{$k}->[1], "\n";
#		    }
#		    dump(%file_summary);
		}
		else {
		    print "Apid $apid not found\n";
		}

=pod
                if($apid == $archive->sts1_apid()) {
		    $file_summary{$archive->sts1_apid()}->[0] = $archive->sequence_count() if $sts1_start;
                    $sts1_start = 0;
                    $sts1_count = $archive->sequence_count();
                    ++$sts1_count;
		    # get seq flag
                    next;
                }

                if($archive->packetApid() == $archive->sts2_apid()) {
                    $sts2_start_count = $archive->sequence_count() if $sts2_start;
                    $sts2_start = 0;
                    $sts2_end_count = $archive->sequence_count();
                    ++$sts2_count;
                    next;
                }

                if($archive->packetApid() == $archive->sts3_apid()) {
                    $sts3_start_count = $archive->sequence_count() if $sts3_start;
                    $sts3_start = 0;
                    $sts3_end_count = $archive->sequence_count();
                    ++$sts3_count;
                    next;
		}

                if($archive->packetApid() == $archive->hk1_apid()) {
                    $hk1_start_count = $archive->sequence_count() if $hk1_start;
                    $hk1_start = 0;
                    $hk1_end_count = $archive->sequence_count();
                    ++$hk1_count;
                    next;
		}

                if($archive->packetApid() == $archive->hk2_apid()) {
                    $hk2_start_count = $archive->sequence_count() if $hk2_start;
                    $hk2_start = 0;
                    $hk2_end_count = $archive->sequence_count();
                    ++$hk2_count;
                    next;
		}

                if($archive->packetApid() == $archive->hk1_apid()) {
                    $aocs_start_count = $archive->sequence_count() if $aocs_start;
                    $aocs_start = 0;
                    $aocs_end_count = $archive->sequence_count();
                    ++$aocs_count;
                    next;
		}

                if($archive->packetApid() == $archive->sot_apid()) {
                    $sot_start_count = $archive->sequence_count() if $sot_start;
                    $sot_start = 0;
                    $sot_end_count = $archive->sequence_count();
                    ++$sot_count;
                    next;
		}

                if($archive->packetApid() == $archive->eismdp_apid()) {
                    $eismdp_start_count = $archive->sequence_count() if $eismdp_start;
                    $eismdp_start = 0;
                    $eismdp_end_count = $archive->sequence_count();
                    ++$eismdp_count;
                    next;
		}
=cut
            }
            else {
                print STDERR "Failed to get first packet\n" if $seen_packet == 0;
#               $archive->closeInput();                                                                                                                         
                last;
            }
	}
    }
    else {
        print STDERR "Failed to open file $file : $!\n";
    }
#    close OUT;                                                                                                                                                 

#    write;

#    print "apids = ", %status_apids, "\n";

    print "\n\n";

    foreach my $k (sort %file_summary) {
	print "$k -> ", $file_summary{$k}[0], "\t", $file_summary{$k}[1], "\t", $file_summary{$k}[2], "\n";
    }

}

sub dump {
    my %foo = @_;
    foreach my $k (sort %foo) {
	print "$k -> ", $foo{$k}->[0], "\t", $foo{$k}->[1], "\n";
    }
}

sub message {
    my $message = shift;
    
    print STDERR "$message\n";
}

#format STDOUT_TOP =
#                            ------- STS1 ------- ------- STS2 ------- ------- STS3 ------- ---HK1---
#Filename                     Total  Start    End  Total  Start    End  Total  Start    End   Total
#.
#
#format STDOUT =
#@<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>> @>>>>> @>>>>> @>>>>> @>>>>> @>>>>> @>>>>> @>>>>> @>>>>> @>>>>>>
#$file, $sts1_count, $sts1_start_count, $sts1_end_count, $sts2_count, $sts2_start_count, $sts2_end_count, $sts3_count, $sts3_start_count, $sts3_end_count, $hk1_count
#.
