#!/usr/bin/env perl

=pod

#title
The EIS study2 database : Version 0.0 12/07/2005

#maxentries
500000

#itemsN
    SY_ID               I*4      related study IDN
    RA_INDEX            I*2      raster index (in study)n
    RA_ID               I*4      raster ID (for this raster)N
    RA_REPEATS          I*2      number of repeats (for this raster)n
    RA_NWINDOWS         I*2      number of data windows (etc.)n
    RA_COMPRESSION      B*1      compression factorC
    RA_DURATION         I*8      duration in msNN
    RA_VOLUME           I*8      volume in kbitsNN
    RA_AEC_FLG(25)      B*1      line flagged for AECC25
    RA_AEC_PROPS(6)     I*4N6
    RA_EIS_FLR_FLG(25)  B*1      line flagged for detecting EIS flaresC25
    RA_EIS_FLR_PROPS(6) I*4N6
    RA_EIS_EVT_FLG(25)  B*1      line flagged for detecting EIS eventsC25
    RA_EIS_EVT_PROPS(4) I*4N4
    RA_XRT_PROPS        B*4      (respond to) XRT flareC4
    ASRC_ENABLED        B*1      Anti-spacecraft Roll enabled/disabledC
    ASRC_DIRECTION      B*1      ASCR direction (0/1 = forward/backward)C
    ASRC_SKIP           B*1      ASCR direction (1/2)C
    ASRC_NSTEPS         I*4      ASCR number of compensation stepsN

#index
SY_ID          index

709, 594, 0, 564, 1, 11, 1, 0, 482325, [0], [0], [0], [0], [0], [174], [76], 0, 0, 0, 0
710, 595, 0, 565, 1, 11, 1, 0, 3472738, [0], [0], [0], [0], [4], [230], [240], 0, 0, 0, 0
711, 596, 0, 566, 1, 11, 1, 0, 3346494, [0], [0], [0], [0], [13], [157], [240], 0, 0, 0, 0

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $study_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/technical_db/eis_study2_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $study_db: $!" unless sysopen(DB, $study_db, O_RDONLY);
    
# Read 0x148 bytes of junk at start
my $num_read = sysread DB, $buffer, 0xB8;

my $format;

if ($comma_delimit_lists) {
#    $format = "NNnNnnCNNC25n6C25n6C25n4C4CCCn";
    $format = "NNnNnnCNNNNC25N6C25N6C25N4C4CCCN";
}
else {
    $format = "NNnNnnCNNC25n6C25n6C25n4C4CCCn";
}

while (1) {
    
    $num_read = sysread DB, $buffer, 184;
    last if $num_read == 0;

#    my ($en, $stid, $in, $raid, $nrep, $nwin, $comp) = unpack "NNnNnnC", $buffer;
#    print "$en, $stid, $in, $raid, $nrep, $nwin, $comp\n";
    my ($en, $stid, $in, $raid, $nrep, $nwin, $comp, $p,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9,$p10,$p11,$p12,$p13) = unpack $format, $buffer;
    print "$en|$stid|$in|$raid|$nrep|$nwin|$comp|$p|$p2|[$p3]|[$p4]|[$p5]|[$p6]|[$p7]|[$p8]|[$p9]|$p10|$p11|$p12|$p13\n";
}

close DB;
