#!/usr/local/bin/perl

# Reads .dbf file

#
#maxentries
#500000
# 
##items
#write_locked    B*1      (=1) If study is archived in mission DB
#ID              I*4      ID (computer generated)
#ACRONYM         C*20     acronym (user supplied)
#TITLE           C*100    title (computer generated)
#TYPE            B*1      type (0/1 = science/engineering)
#TARGET          C*20     generic target
#AUTHOR          C*20     author(s)
#CATEGORY        C*20     category
#DATE            C*20     creation date
#DESC_FILE       C*20     name of text file containing ASCII study description
#DURATION        I*8      nominal duration for this study (ms)
#DATA_VOLUME     I*8      nominal volume for this study
#N_RASTERS       I*2      number of rasters in this study
#RECURSIVE       I*2      indicates whether this study may be a default study
#SLIT_SLOT(3)    I*2      slit-slot parameters (change count, first index, last index)
#AEC_RESPONSE    I*4      response parameters for AEC
#EIS_FLR_RES(5)  I*4
#EIS_EVT_RES(5)  I*4
#XRT_FLR_RES(7)  I*4
# 
##index
#ID          index
#

die unless $#ARGV == 0;
$db = shift;
open(DB, "< $db") or die "Can't open $db: $!\n";
##$count = read(DB, $junk, (20 * 16) + 12);
#$count = read(DB, $junk, (20 * 16) + 4);
$count = read(DB, $junk, 0x148);
while(!eof(DB)) {
    extract_parameters();
    print_parameters();
}
close DB;

sub extract_parameters {
    $count = read(DB, $write_locked,  1);
    $count = read(DB, $id,            4);
    $count = read(DB, $acronym,      20);
    $count = read(DB, $title,       100);
    $count = read(DB, $type,          1);
    $count = read(DB, $target,       20);
    $count = read(DB, $author,       20);
    $count = read(DB, $category,     20);
    $count = read(DB, $date,         20);
    $count = read(DB, $desc_file,    20);
    $count = read(DB, $duration,      8);
    $count = read(DB, $data_volume,   8);
    $count = read(DB, $n_rasters,     2);
    $count = read(DB, $recursive,     2);
    $count = read(DB, $slit_slot,     2 * 3);
    $count = read(DB, $aec_response,  4);
    $count = read(DB, $eis_flr_res,   4 * 5);
    $count = read(DB, $eis_evt_res,   4 * 5);
#    $count = read(DB, $xrt_flr_res,   4 * 7);
    $count = read(DB, $xrt_flr_res,   4 * 6);

#    $count = read(DB, $junk, 4);
#    $count = read(DB, $junk, 16);

    @write_locked = unpack "C*", $write_locked;
    @id           = unpack "C*", $id;
    @type         = unpack "C*", $type;

    @duration     = unpack "C*", $duration;
    @data_volume  = unpack "C*", $data_volume;
    @n_rasters    = unpack "C*", $n_rasters;
    @recursive    = unpack "C*", $recursive;
    @slit_slot    = unpack "C*", $slit_slot;
    @aec_response = unpack "C*", $aec_response;
    @eis_flr_res  = unpack "C*", $eis_flr_res;
    @eis_evt_res  = unpack "C*", $eis_evt_res;
    @xrt_flr_res  = unpack "C*", $xrt_flr_res;

}

sub print_parameters {
    dump_list_parameter("Write locked : [", \@write_locked);
    dump_list_parameter1("Id           : [", \@id);
    print "Acronym      : [$acronym]\n";
    print "title        : [$title]\n";
    dump_list_parameter("Type         : [", \@type);
    print "Target       : [$target]\n";
    print "Author       : [$author]\n";
    print "Category     : [$category]\n";
    print "Date         : [$date]\n";
    print "Desc file    : [$desc_file]\n";
    dump_list_parameter("Duration     : [", \@duration);
    dump_list_parameter("Data volume  : [", \@data_volume);
    dump_list_parameter("N rasters    : [", \@n_rasters);
    dump_list_parameter("Recursive    : [", \@recursive);
    dump_list_parameter("Slit slot    : [", \@slit_slot);
    dump_list_parameter("Aec response : [", \@aec_response);
    dump_list_parameter("Eis flr res  : [", \@eis_flr_res);
    dump_list_parameter("Eis evt res  : [", \@eis_evt_res);
    dump_list_parameter("Xrt flr res  : [", \@xrt_flr_res);
    print "\n";
}

sub dump_parameter {
    my $title = shift;
    
}

sub dump_list_parameter {
    my $title = shift;
    my $list = shift;
    my $str = "";

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    print "$str]\n";
}

sub dump_list_parameter1 {
    my $title = shift;
    my $list = shift;
    my $str = "";
    my $num;

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    $num = sprintf "%u", hex($str);
    print "$str ($num)]\n";
}
