#!/usr/local/bin/perl

=pod

Reads .dbf file


maxentries
500000
 
#items
write_locked    B*1     N    (=1) If study is archived in mission DB
ID              I*4     C    ID (computer generated)
ACRONYM         C*20    A20  acronym (user supplied)
TITLE           C*100   A100 title (computer generated)
TYPE            B*1     C    type (0/1 = science/engineering)
TARGET          C*20    A20  generic target
AUTHOR          C*20    A20  author(s)
CATEGORY        C*20    A20  category
DATE            C*20    A20  creation date
DESC_FILE       C*20    A20  name of text file containing ASCII study description
DURATION        I*8     NN   nominal duration for this study (ms)
DATA_VOLUME     I*8     NN   nominal volume for this study
N_RASTERS       I*2     n    number of rasters in this study
RECURSIVE       I*2     n    indicates whether this study may be a default study
SLIT_SLOT(3)    I*2     nnn  slit-slot parameters (change count, first index, last index)
AEC_RESPONSE    I*4     N    response parameters for AEC
EIS_FLR_RES(5)  I*4	N5
EIS_EVT_RES(5)  I*4	N5
XRT_FLR_RES(7)  I*4	N7
 
#index
ID          index

=cut


my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $study_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/technical_db/eis_study_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $study_db: $!" unless sysopen(DB, $study_db, O_RDONLY);

my $format;

if ($comma_delimit_lists) {
    $format = "NCNA20A100CA20A20A20A20A20NNNNnnnnnNN5N5N7";
###    $format = "NCNA20A100CA20A20A20A20A20NNNNnnnnnNN5N5N7C*";
}
else {
    $format = "NCNA20A100CA20A20A20A20A20NNNNnnnnnN";
}
    
# Read 0x148 bytes of junk at start
my $num_read = sysread DB, $buffer, 0x148;

while (1) {
    
    $num_read = sysread DB, $buffer, 328;
    last if $num_read == 0;

    if ($comma_delimit_lists) {
	my ($en,$wl,$id,$acr,$ti,$ty,$ta,$au,$ca,$da,$desc,$durms,$durls,$volms,$volls,$nr,$rec,$sla_cc,$sla_fi,$sla_li,$aec,$f,$f1,$f2,$f3,$f4,$e,$e1,$e2,$e3,$e4,$x,$x1,$x2,$x3,$x4,$x5,$x6,@rest) = unpack $format, $buffer;
	print "$en|$wl|$id|'$acr'|'$ti'|$ty|'$ta'|'$au'|'$ca'|'$da'|'$desc'|$durms|$durls|$volms|$volls|$nr|$rec|$sla_cc|$sla_fi|$sla_li|$aec|[$f,$f1,$f2,$f3,$f4]|[$e,$e1,$e2,$e3,$e4]|[$x,$x1,$x2,$x3,$x4,$x5,$x6]\n";
    }
    else {
#	my ($en, $wl, $id, $acr, $ti, $ty, $ta, $au, $ca, $da, $desc, $durms, $durls, $volms, $volls, $nr, $rec, $sla_cc, $sla_fi, $sla_li, $aec) = unpack "NCNA20A100CA20A20A20A20A20NNNNnnnnnN", $buffer;
	my ($en, $wl, $id, $acr, $ti, $ty, $ta, $au, $ca, $da, $desc, $durms, $durls, $volms, $volls, $nr, $rec, $sla_cc, $sla_fi, $sla_li, $aec) = unpack $format, $buffer;
	my @eis_flr_resp = unpack "x259N5", $buffer;
	my @eis_evt_resp = unpack "x279N5", $buffer;
	my @xrt_flr_resp = unpack "x299N7", $buffer;
	my @rest         = unpack "x327C*", $buffer;
	#EIS_FLR_RES(5)  I*4
	#EIS_EVT_RES(5)  I*4
	#XRT_FLR_RES(7)  I*4

	my $study_type = ($ty == 0) ? 'science' : 'engineering';

	#    print "$en, $wl, $id, '$acr', '$ti', $ty, '$ta', '$au', '$ca', '$da', '$desc', $durms, $durls, $volms, $volls, $nr, $rec, $sla_cc, $sla_fi, $sla_li, $aec\n";
###print "$en|$wl|$id|'$acr'|'$ti'|$ty|'$ta'|'$au'|'$ca'|'$da'|'$desc'|$durms|$durls|$volms|$volls|$nr|$rec|$sla_cc|$sla_fi|$sla_li|$aec|[@eis_flr_resp]|[@eis_evt_resp]|[@xrt_flr_resp]\n";
######	print "$en|$wl|$id|'$acr'|'$ti'|'$study_type'|'$ta'|'$au'|'$ca'|'$da'|'$desc'|$durms|$durls|$volms|$volls|$nr|$rec|$sla_cc|$sla_fi|$sla_li|$aec|[@eis_flr_resp]|[@eis_evt_resp]|[@xrt_flr_resp]\n";

	print "Entry        : [$en]\n";
	print "Write locked : [$wl]\n";
	print "Id           : [$id]\n";
	print "Acronym      : ['$acr']\n";
	print "Title        : ['$ti']\n";
	print "Type         : ['$study_type']\n";
	print "Target       : ['$ta']\n";
	print "Author       : ['$au']\n";
	print "Category     : ['$ca']\n";
	print "Date         : ['$da']\n";
	print "Desc file    : ['$desc']\n";
	print "Duration     : [$durms], [$durls]\n";
	print "Data volume  : [$volms], [$volls]\n";
	print "N rasters    : [$nr]\n";
	print "Recursive    : [$rec]\n";
	print "Slit/slot    : [$sla_cc], [$sla_fi], [$sla_li]\n";
	print "Aec response : [$aec]\n";
	print "Eis flr res  : [@eis_flr_resp]\n";
	print "Eis evt res  : [@eis_evt_resp]\n";
	print "Xrt flr res  : [@xrt_flr_resp]\n\n";
    }
}

close DB;

sub extract_parameters {

    @write_locked = unpack "C*", $write_locked;
    @id           = unpack "C*", $id;
    @type         = unpack "C*", $type;

    @duration     = unpack "C*", $duration;
    @data_volume  = unpack "C*", $data_volume;
    @n_rasters    = unpack "C*", $n_rasters;
    @recursive    = unpack "C*", $recursive;
    @slit_slot    = unpack "C*", $slit_slot;
    @aec_response = unpack "C*", $aec_response;
    @eis_flr_res  = unpack "C*", $eis_flr_res;
    @eis_evt_res  = unpack "C*", $eis_evt_res;
    @xrt_flr_res  = unpack "C*", $xrt_flr_res;

}

sub print_parameters {
    dump_list_parameter("Write locked : [", \@write_locked);
    dump_list_parameter1("Id           : [", \@id);
    print "Acronym      : [$acronym]\n";
    print "title        : [$title]\n";
    dump_list_parameter("Type         : [", \@type);
    print "Target       : [$target]\n";
    print "Author       : [$author]\n";
    print "Category     : [$category]\n";
    print "Date         : [$date]\n";
    print "Desc file    : [$desc_file]\n";
    dump_list_parameter("Duration     : [", \@duration);
    dump_list_parameter("Data volume  : [", \@data_volume);
    dump_list_parameter("N rasters    : [", \@n_rasters);
    dump_list_parameter("Recursive    : [", \@recursive);
    dump_list_parameter("Slit slot    : [", \@slit_slot);
    dump_list_parameter("Aec response : [", \@aec_response);
    dump_list_parameter("Eis flr res  : [", \@eis_flr_res);
    dump_list_parameter("Eis evt res  : [", \@eis_evt_res);
    dump_list_parameter("Xrt flr res  : [", \@xrt_flr_res);
    print "\n";
}

sub dump_parameter {
    my $title = shift;
    
}

sub dump_list_parameter {
    my $title = shift;
    my $list = shift;
    my $str = "";

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    print "$str]\n";
}

sub dump_list_parameter1 {
    my $title = shift;
    my $list = shift;
    my $str = "";
    my $num;

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    $num = sprintf "%u", hex($str);
    print "$str ($num)]\n";
}
