#!/usr/bin/env perl

use bigint;

=pod

#title
The EIS timeline database : Version 0.1 02/01/2005

#maxentries
500000

#itemsn
    START_TIME      R*8      start time for this plan entry (tai)NN
    STOP_TIME       R*8      end time for this plan entry (tai)NN
    WRITE_LOCKED    I*2      lock - set to 1 to indicate locked, i.e. must not be changedn
    TIME_TAGGED     B*1      link to previous study 0:invalid 1:linked 2:time_taggedC
    FIVE_PC_RULE    B*1      apply five percent rule.C
    ENTRY_TYPE      C*1      entry type I, S, E, P, R, B, AA
    ACRONYM         C*20A20
    ST_ID           I*4N
    TITLE           C*100    title (computer generated)A100
    AUTHOR          C*20     author(s)A20
    CATEGORY        C*20     categoryA20
    SEQUENCE_ID     I*4      sequence ID associated with this entry (-1 is suspension period)N

#index
START_TIME          index

=cut

my $comma_delimit_lists = 0;
if ($#ARGV == 0) {
    $comma_delimit_lists = 1 if ($ARGV[0] eq "-c");
}

my $timeline_db = $ENV{'SSW'} . "/hinode/eis/database/planning_db/timeline_db/eis_timeline_db.dbf";
my $buffer;
my $raster_id;

die "Can't open $timeline_db: $!" unless sysopen(DB, $timeline_db, O_RDONLY);
    
# Read 198 bytes of junk at start
my $num_read = sysread DB, $buffer, 198;

while (1) {
    
    $num_read = sysread DB, $buffer, 196;
    last if $num_read == 0;

#    my ($en, $strtms,$strtls, $stpms,$stpls, $wl, $tt, $fpc, $et, $acr, $stid, $t, $a, $c, $sid, $strt1) = unpack "nNNNNnCCAA20NA100A20A20NN", $buffer;
    my ($en, $strtms,$strtls, $stpms,$stpls, $wl, $tt, $fpc, $et, $acr, $stid, $t, $a, $c, $sid, $strt1) = unpack "nNNNNnCCAA20NA100A20A20NN", $buffer;
#    print "$en|$strtms|$strtls|$stpms|$stpls|$wl|$tt|$fpc|'$et'|'$acr'|$stid|'$t'|'$a'|'$c'|$sid|$strt1\n";
    $strt1 = 0 if $strt1 == '';
    print "$sid|$strtms|$strtls|$stpms|$stpls|$wl|$tt|$fpc|'$et'|'$acr'|$stid|'$t'|'$a'|'$c'|$sid|$strt1\n";
}

close DB;
