#!/usr/local/bin/perl

#
#maxentries
#500000
# 
#items
#START_TIME      R*8      start time for this plan entry (tai)
#STOP_TIME       R*8      end time for this plan entry (tai)
#WRITE_LOCKED    I*2      lock - set to 1 to indicate locked, i.e. must not be changed
#TIME_TAGGED     B*1      link to previous study 0:invalid 1:linked 2:time_tagged
#FIVE_PC_RULE    B*1      apply five percent rule.
#ENTRY_TYPE      C*1      entry type I, S, E, P, R, B, A and D
#ACRONYM         C*20
#ST_ID           I*4
#TITLE           C*100    title (computer generated)
#AUTHOR          C*20     author(s)
#CATEGORY        C*20     category
#SEQUENCE_ID     I*4      sequence ID associated with this entry (-1 is suspension period)
# 
##index
#START_TIME          index
#
die unless $#ARGV == 0;
$db = shift;
open(DB, "< $db") or die "Can't open $db: $!\n";

$count = read(DB, $junk, 12);
$count = read(DB, $junk, 188);
while(!eof(DB)) {
    extract_parameters();
    print_parameters();
}
close DB;

sub extract_parameters {
#    $count = read(DB, $junk, 12);
#    $count = read(DB, $junk, 188);
    $count = read(DB, $start_time,    8);
    $count = read(DB, $stop_time,     8);
    $count = read(DB, $write_locked,  2);
    $count = read(DB, $time_tagged,   1);
    $count = read(DB, $five_pc_rule,  1);
    $count = read(DB, $entry_type,    1);
    $count = read(DB, $acronym,      20);
    $count = read(DB, $st_id,         4);
    $count = read(DB, $title,       100);
    $count = read(DB, $author,       20);
    $count = read(DB, $category,     20);
    $count = read(DB, $sequence_id,   4);

#$count = read(DB, $junk, 12);
#
#$count = read(DB, $start_time,   96);
#$count = read(DB, $stop_time,    96);
#$count = read(DB, $write_locked,  8);
#$count = read(DB, $time_tagged,   4);
#$count = read(DB, $five_pc_rule,  4);
#$count = read(DB, $entry_type,    1);
#$count = read(DB, $acronym,      20);
#$count = read(DB, $st_id,        4);
#$count = read(DB, $title,       100);
#$count = read(DB, $author,       20);
#$count = read(DB, $category,     20);
#$count = read(DB, $sequence_id,  16);

##    $count = read(DB, $junk, 3);
    $count = read(DB, $junk, 7);


    @start_time = unpack "C*", $start_time;
#    $start_time = sprintf "%08X", $start_time;
    @stop_time = unpack "C*", $stop_time;
#    $stop_time = sprintf "%08X", $stop_time;
    @write_locked = unpack "C*", $write_locked;
    @time_tagged = unpack "C*", $time_tagged;
    @five_pc_rule = unpack "C*", $five_pc_rule;
    @st_id = unpack "C*", $st_id;
    @sequence_id = unpack "C*", $sequence_id;
#    $sequence_id = sprintf "%08X", $sequence_id;
}

sub print_parameters {
    dump_parameter("Start time   : '", \@start_time);
    dump_parameter("Stop time    : '", \@stop_time);
    print "Write locked : '@write_locked'\n";
    print "Time tagged  : '@time_tagged'\n";
    print "Five pc rule : '@five_pc_rule'\n";
    print "Entry type   : '$entry_type'\n";
    print "Acronym      : '$acronym'\n";
    dump_list_parameter1("Study id     : '", \@st_id);
    print "Title        : '$title'\n";
    print "Author       : '$author'\n";
    print "Category     : '$category'\n";
    dump_list_parameter1("Sequence id  : '", \@sequence_id);
    print "\n";
}

sub dump_parameter {
    my $title = shift;
    my $list = shift;
    my $str = "";

#    foreach $i (@$list) {
#print "Foo ";
#    }
#    return;
    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
#    chop $str;
    print "$str'\n";
}

sub dump_list_parameter1 {
    my $title = shift;
    my $list = shift;
    my $str = "";
    my $num;

    print $title;
    foreach $i (@$list) {
	$str .= sprintf("%02X", $i);
    }
    $num = sprintf "%u", hex($str);
    print "$str ($num)'\n";
}
