#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$src_dir   = "$HOME/tmp";
$exp_count = "exp_count";
$exp_rec   = "exp_rec";
$db_dir    = "$HOME/work/localdata/database/exposure";
$db        = "exposures_";

foreach $year (2006 .. 2008) {
    dbmopen(%ra_db, "$db_dir/$db$year.db", '0777') or die "Can't open database $db$year.db: $!";
    foreach $month (01 02 03 04 05 06 07 08 09 10 11 12) {
	if(!open(EC, "<$src_dir/$exp_count_$year$month.txt")) {
	    print STDERR "Couldn't open $src_dir/$exp_count_$year$month.txt: $!\n";
	    next;
	}
	if(!open(ER, "<$src_dir/$exp_rec_$year$month.txt")) {
	    print STDERR "Couldn't open $src_dir/$exp_rec_$year$month.txt: $!\n";
	    next;
	}
	@ec = <EC>;
	@er = <ER>;
	

foreach $db (@dbs) {
    open(FH, "< $src_dir/$db") or warn "Can't open database $db: $!";
    while(<FH>) {
	next if /^[ ]+Id/;
	chomp;
	@data = split;
	$key = shift @data;
	if($db =~ m/raster_db/) {
	    push @data, "0";
	}
	$line = join ' ', @data;
	$line =~ s/[ ]+/ /g;
#	print "$key -> $line\n";
	$ra_db{$key} = $line;
    }
    close FH;
}

dbmclose %ra_db;

# Expect 2 arguments: year (yyyy) and a directory name



#$year = shift;
#$dir  = shift;

#print "$year $dir\n";

#while(<>) {

#}
