;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006	mcrw wrote
;
;-------------------------------------------------------------------------------------------------

pro eis_md_decomp_fix1_script, dir, merge=merge

  print, '~/work/idl/eis_md_decomp_fix1_script'
  message, '~/work/idl/eis_md_decomp_fix1_script', /info

    count = 0L
;;;    files = findfile(dir + '/eis_md_*', count=count)
    files = file_search(dir + '/eis_md_*', count=count)

    if count eq 0 then begin
        print, 'No files'
        return
    endif

    for i = 0, count - 1 do begin
        print, 'eis_md_decomp_fix1, ' + strtrim(string(files[i]), 2) + ', merge=merge'
        message, 'eis_md_decomp_fix1, ' + strtrim(string(files[i]), 2) + ', merge=merge', /info
        eis_md_decomp_fix1,files[i], merge=merge
    endfor

end
