#!/bin/sh

# rescue.sh [-m] plan_run_date

echo At 0

# Set up defaults
merge_rescue=0
log_file_suffix="rescue_${1}"

# Check args
if [ $# -gt 1 ]; then
    if [ $1 == "-m" ]; then
	merge_rescue=1
    fi
    log_file_suffix="rescue_${2}"
fi

echo At 1

rescue_dir=${HOME}/work/localdata/sdtp/merge/rescue
merge_dir=${HOME}/work/localdata/sdtp/merge

decomp_dir=${HOME}/work/localdata/sdtp/merge/decompressed

###log_file=$HOME/work/localdata/log/rescue/rescue_$@
log_file=${HOME}/work/localdata/log/rescue/${log_file_suffix}
hdr_file=${HOME}/work/localdata/log/rescue/rescue_format.txt
fits_dir=${HOME}/work/localdata/pipeline/fits

soda_dir=/soda/hinode/eis/level0
log_dir=${HOME}/data/staging/logs/pipeline_mission/rescue

echo At 2

#if [ -e ${log_file} ]; then
#    /bin/rm ${log_file}
#    touch ${log_file}
#fi

echo At 3

/bin/rm ${merge_dir}/eis_*
/bin/rm ${decomp_dir}/eis_*

echo At 4

# Don't remove the fits files if rescue.sh called during merge reformat
if [ ${merge_rescue} -eq 0 ]; then
    /bin/rm ${fits_dir}/eis_*
fi

echo At 5

cat ${hdr_file} > ${log_file}
for f in `ls ${rescue_dir}` ; do
    ${HOME}/bin/rescue_file.pl ${rescue_dir}/${f} >> ${log_file}
#    echo $f >> $RESCUE_RECORD
done

#exit

echo At 6

# $@ is all the positional parameters
rescue_decomp.pl $@

echo At 7

###rescue_reformat.pl $@
rescue_reformat1.pl $@

# Now move fits files to /soda
#for f in `ls $fits_dir` ; do
#    y=${f:7:4}
#    m=${f:11:2}
#    d=${f:13:2}
#    echo "mv $fits_dir/$f $soda_dir/$y/$m/$d"
#    mv $fits_dir/$f $soda_dir/$y/$m/$d
#done

echo At 8

# Now remove ccsds files from rescue, merge, decompressed
blf=`basename ${log_file}`
/bin/mv ${log_file} ${log_dir}/${blf}
