#!/usr/local/bin/perl

use Time::Local;
use Date::Calc;
use File::Basename;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
do "$EGSE_SW_LIB/pipeline.pl"      || die "Can't do pipeline.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log_rescue.txt") || die "Can't open $pipeline_log/$pipeline_log_rescue.txt for writing: $!";
print MLOG scalar(localtime), " (JST) rescue_decomp.pl started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "interactive";
if($#ARGV != -1) {
    $state = "interactive";
    if($#ARGV == 1) { $flag = shift; }
    if(@ARGV) { $sdate  = shift; }
}

$pipeline_mission_rescue_log = "$pipeline_log/pipeline_mission_rescue_log_rescue_$sdate";
open(LOG, ">> $pipeline_mission_rescue_log") || die "Can't open $pipeline_mission_rescue_log for writing: $!";
print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
print MLOG "manually for $sdate\n";

$date_string  = $sdate;


############################################### 8 - MISSION DATA DECOMPRESS

print STDOUT scalar(localtime), " (JST) - Starting mission data decompress\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting mission data decompress\n";

@files = `ls $merge_dir/eis_md*`;
###@files = `ls $merge_dir/merge1/eis_md*`;
$pre_check_count = @files;
print STDOUT "Files for rescue:\n@files\n";
print LOG "Files for rescue:\n@files\n";
$zero_sized_count = 0;
foreach $f (@files) {
    chomp $f;
    @stat = stat $f;
    if($stat[7] == 0) {
	++$zero_sized_count;
	$f1 = basename($f);
	print STDOUT "\t$f is zero-sized, moving to incomplete\n";
	print LOG "\t$f is zero-sized, moving to incomplete\n";
	system("/bin/mv $merge_dir/rescue/$f1 $merge_dir/incomplete/");
	system("/bin/rm $merge_dir/$f1");
###	system("/bin/rm $merge_dir/merge1/$f1");
    }
}
$post_check_count = $pre_check_count - $zero_sized_count;

print STDOUT "$pre_check_count files sent for rescue, $zero_sized_count empty, $post_check_count files rescued\n\n";
print LOG "$pre_check_count files sent for rescue, $zero_sized_count empty, $post_check_count files rescued\n\n";

@rescued_files = `ls $merge_dir/eis_md*`;
###@rescued_files = `ls $merge_dir/merge1/eis_md*`;
print STDOUT "Rescued Files:\n@rescued_files\n";
print LOG "Rescued Files:\n@rescued_files\n";

print STDOUT "(IDL) eis_md_decomp_script,'$merge_dir', /merge\n\n";
print LOG "(IDL) eis_md_decomp_script,'$merge_dir', /merge\n\n";
###print LOG "\t(IDL) eis_md_decomp_script,'$merge_dir/merge1', /merge\n";

# mcrw 20240321

$output = <<EOF;
print, 'STARTING eis_md_decomp_fix1_script'
!quiet=0
print, 'STARTING eis_md_decomp_fix1_script'
; mcrw 20240703
.comp $local_idl/eis_ccsds_interface__define
.comp $local_idl/mdppmdctrecover
;.comp $local_idl/eis_md_decomp
;.comp $local_idl/eis_md_decomp_script
;eis_md_decomp_script,'$merge_dir', /merge
print, 'COMPILING mdppmdctrecover'
.comp $local_idl/mdppmdctrecover
print, 'COMPILING $local_idl/eis_md_decomp_fix1'
.comp $local_idl/eis_md_decomp_fix1
print, 'COMPILING $local_idl/eis_md_decomp_fix1_script'
.comp $local_idl/eis_md_decomp_fix1_script
;eis_md_decomp_fix1_script,'$merge_dir/merge1', /merge
print, 'RUNNING eis_md_decomp_fix1_script, $merge_dir, \/merge'
eis_md_decomp_fix1_script,'$merge_dir', /merge
EOF


print "~/src/rescue_decomp.pl : Writing IDL to $temp_idl/md_decomp_rescue.pro\n";

# $temp_idl = ~/work/localdata/pipeline/idl

open(MD_DECOMP, "> $temp_idl/md_decomp_rescue.pro");
print MD_DECOMP $output;
close MD_DECOMP;

# Start the mission data decompress

$output_log = "$pipeline_log/md_decompress_rescue_" . $date_string . ".txt";
print STDOUT "~/src/rescue_decomp.pl output_log = $output_log\n";
print LOG "~/src/rescue_decomp.pl output_log = $output_log\n";

#system("/nasA_solar1/home/sbukeis/ssw_idl < $temp_idl/md_decomp.pro > $output_log");

print STDOUT "~/src/rescue_decomp.pl: Starting IDL md_decomp_rescue\n";

# For new reformatter - mcrw 20131206
system("$HOME/ssw_idl < $temp_idl/md_decomp_rescue.pro > $output_log"); # This runs eis_md_decomp_fix1_script
#system("$HOME/ssw_idl < $new_idl/decompression/md_decomp_rescue.pro > $output_log"); # This runs eis_md_decomp_fix1_script

log_msg(*LOG, $state, "/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");

#log_msg(*LOG, $state, "/bin/mv $pipeline_log/md_decompress_rescue_$date_string.txt $darts_staging/logs/decompression/");
log_msg(*LOG, $state, "/bin/mv $output_log $darts_staging/logs/decompression/");
system("/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");

#system("/bin/mv $pipeline_log/md_decompress_rescue_$date_string.txt $darts_staging/logs/decompression/");
#######system("/bin/mv $output_log $darts_staging/logs/decompression/");
perform(*LOG, $state, "$HOME/bin/slim.pl < $output_log > $darts_staging/logs/decompression/rescue/md_decompress_rescue_$date_string.txt");

#system("/bin/cp $HOME/work/localdata/sdtp/decompressed/merge_decomp_record.txt $darts_staging/decompression/");
#system("/bin/cp $pipeline_log/md_decompress_manual_$date_string.txt $darts_staging/decompression/");
#system("remove_decomp_junk");
@post_decompression = `ls $merge_dir/decompressed/ | grep eis_md`;
###@post_decompression = `ls $merge_dir/merge1/decompressed1/ | grep eis_md`;
$number_post_decompression = @post_decompression;
log_msg(*LOG, $state, "Number of de-compressed files: $number_post_decompression");

log_msg(*LOG, $state, "rescue_decomp finished");
print MLOG scalar(localtime), " (JST) ~/src/rescue_decomp.pl finished\n";
###pipeline_exit("rescue");
