#!/usr/local/bin/perl -W

# foreach f ( `ls ~/work/localdata/sdtp/merge/rescue/` )
# rescue_file.pl ~/work/localdata/sdtp/merge/rescue/$f
# end

# -m switch indicates the program was called by daily_merge_mission1

use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";
use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds";
use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds/Packet";

use Ccsds;
use Packet;
use Ccsds::Packet::GapReader;
use File::Basename;

use Env qw(EGSE_SW_LIB);

#do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
#print STDERR "rescue_file.pl\n";

$outputDir = "/nasA_solar1/work/eis/localdata/sdtp/merge/";
$filename = "";
if($#ARGV == 0) {
    $filename = $ARGV[0] unless $ARGV[0] eq "-m";
    die "Incorrect parameters" if $filename eq "";
}
elsif($#ARGV == 1) {
    die "Unknown switch" unless $ARGV[0] eq "-m";
    $filename = $ARGV[1];
    $outputDir = "/nasA_solar1/work/eis/localdata/sdtp/merge/merge1/";
}
else {
    print STDERR "Supply filename to process\n";
    exit;
}
# mcrw 20240325
#print STDERR "Filename = $filename\n";
#die;

$outputFile = basename($filename);
$outputFilename = "$outputDir" . "$outputFile";

# mcrw 20240325
#die "Can't open output file: $!" unless open(OUT, "> $outputFilename");
print STDERR "rescue_file.pl: Files: $filename, $outputFilename\n";

$r = Ccsds::Packet::Reader::GapReader->new();
$num_ccsds_pkts = 0;
$r->init();
$r->setInput($filename);
@data = ();
$md_out_count = 0;
$total_gaps = 0;
$packets_missing = 0;
$md_count = 0;
$md_headers = 0;
while(1) {
    last unless $r->readPacket();
    push @data, $r->rawData();
    if($r->isStartPacketOfSequence()) {
	++$md_headers;
	next;
    }
    if($r->isLastPacketOfSequence()) {
	++$md_count;
###		$num_ccsds_pkts += $r->numberOfPackets();
	if($r->numberOfGaps() == 0) {
	    # mcrw 20240325
	    #print OUT @data;
	    ++$md_out_count;
	}
	$total_gaps += $r->numberOfGaps();
	$packets_missing += $r->packetsMissing();
	$r->mark();
	@data = ();
	next;
    }
}
if($r->isMiddlePacketOfSequence()) {
    $total_gaps += $r->numberOfGaps();
    $packets_missing += $r->packetsMissing();
}

$num_ccsds_pkts = $r->numberOfPackets();
$r->cleanUp();

# mcrw 20240325
print STDERR "system(\"/bin/mv $filename $outputDir\");\n";
system("/bin/mv $filename $outputDir");

# mcrw 20240325
#close OUT;

write STDOUT;

format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<<<< @########## @####################### @############### @############### @################## @##################
$outputFile, $md_headers, $md_count, $md_out_count, $num_ccsds_pkts, $packets_missing, $total_gaps
.

