BEGIN {
    printf("%-26s %10s %9s %11s %10s %16s %4s %5s %5s %5s %11s %6s\n","Filename","Packets","Processed","Integers out","Integers in","Compression ratio","Code","dctbl","dpcm12","dct12","Fix applied","Error*");
#    printf("%-26s %-5s %10s %9s %11s %10s %16s %4s %5s %5s %5s %11s %6s\n","Filename","Flags","Packets","Processed","Integers out","Integers in","Compression ratio","Code","dctbl","dpcm12","dct12","Fix applied","Error*");
#    print "Filename\tPackets\tProcessed\tIntegers in\tIntegers out\tCompression ratio\tCode\tdctbl,dpcm12,dct12\tFix applied\tError"
}

END {

}

function print_file(line) {
    start_index = match(line, "eis_md")
    printf(substr(line, start_index, length(line) - start_index + 1) " ")
}

function print_fix(line) {
#    printf("%s", line);
    printf("%11s", substr(line, length(line) - 1));
##    printf(substr(line, 5, 5));
#    where = index(line, "No")
#    printf 1 - where " "
#    where = index(line, "No")
#    printf 1 - where " "
}

function print_error(line) {
    gsub(/^ /,"",line)
    print "'"line"'"
}

/File/          { print_file($2) }
/Packets/       { printf("%10u ", $2) }
/Processed/     { printf("%9u ", $2)  }
/Integers in/   { printf("%12u ", $4) }
/Integers out/  { printf("%11u ", $3) }
/Compression/   { printf("%17.2f ", $2)  }
/comp_code/     { printf("%s ", $3)   }
/dctbl/         { printf("%5u %6u %5u ", $5, $6, $7) }
/Fix/           { print_fix($0)   }
#/Error/         { print_error($2) }
/Recover/         { print_error($2) }
#/^$/            { print "\n" }
