#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<errno.h>
#include	<unistd.h>

#include "doy2date.h"

void doy2date(unsigned long yr,unsigned long day_num, unsigned char *m, unsigned char *d ) {

  char days_in_month[] = {31,28,31,30,31,30,31,31,30,31,30,31};
  unsigned short start_of_month = 1;
  unsigned short end_of_month = 0;
  unsigned short i;
  unsigned short res;

  if((yr % 4) == 0) {	// Divisible by 4, leap year. not bothering with century years
    days_in_month[1] = 29;
  }
  for(i = 0; i < 12; i++) {
    end_of_month += days_in_month[i];
    if(day_num <= end_of_month)
      break;
    start_of_month += days_in_month[i];
  }
  res = day_num - start_of_month + 1;
  //  fprintf(stderr,"i = %u, start = %u, end = %u, day = %u\n",i,start_of_month, end_of_month,res);
  *m = i + 1;
  *d = res;
}
