#!/usr/local/bin/sh

# ./late_new.sh -s 20061016 -r 223000 -e 20061017 -z 000000

# USC34	17  (0x11)
# GNA	154 (0x9A)
# GNB	155 (0x9B)
# MSP1	150 (0x96)

band=3:Allband
sdate=0
edate=$sdate
ant=17
stime=0
etime=0
no=0
verbose=0

# Process command line args
while getopts ":vmhna:b:s:e:r:z:" opt; do
    case $opt in
	v  ) verbose=1 ;;
	s  ) sdate=$OPTARG ;;
	e  ) edate=$OPTARG ;;
	m  ) norm=1 ;;
        n  ) no=1 ;;
	h  ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
	     exit 0 ;;
        a  ) ant=$OPTARG ;;
        b  ) band=$OPTARG ;;
	r  ) stime=$OPTARG ;;
	z  ) etime=$OPTARG ;;
        \? ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
             exit 1
    esac
done
shift $(($OPTIND - 1))

if [ $sdate = 0 ] ; then
    echo "No start date. Exiting"
    exit
fi

if [ $stime = 0 ] ; then
    echo "No start time. Exiting"
    exit
fi

if [ $etime = 0 ] ; then
    echo "No end time. Exiting"
    exit
fi

if [ $edate = 0 ] ; then
    edate=$sdate
fi

if [ $verbose = 1 ] ; then
    echo "BAND:  $band"
    echo "ANT:   $ant"
    echo "START: $sdate"
    echo "END:   $edate"
    echo "STIME: $stime"
    echo "ETIME: $etime"
    echo "NO:    $no"
fi

if [ $no = 1 ] ; then
    exit 0
fi

    ./LATE_NEW <<EOF
$band
$ant
${sdate}${stime}
${edate}${etime}
1:packet
EOF
